#!/bin/bash

# ű·
SCRIPT_PATH=$(cd $(dirname $0);pwd)

# ű
SELF_FILE=$(basename $0)

# ű־·
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog/"

#ű־ļ
LOG_FILE="${LOG_PATH}/${SELF_FILE}.log"

# ùĿ¼
WORK_PATH="/opt/upgrade/easysuite_upgrade/workpath/"

# Ʒ plandata.json productnam
PRODUCT_NAME=""

# · plandata.json src_version-des_version
UPGRADE_PATH=""

# WORK_PATH/UPGRADE_PATH/workpath-PRODUCT_NAME/
CONFIG_PATH=""

# INPUTļ·  plandata.json
INPUT_FILE="${2}/plandata.json"

# űʱ·
TMP_PATH="/opt/oss/log/manager/easysuite_upgrade_config/backup_pre_config_$(date '+%s')"

##########################################
#  ȡ monitor_full_ability ֶ
##########################################
function read_monitor_full_ability()
{
    file_path="${1}"
    python <<END
import json
with open('${file_path}', 'r', encoding='utf-8') as r_stream:
    print(json.load(r_stream).get('productext', {}).get('monitor_full_ability', ''))
END
}

##########################################
#   monitor_full_ability
##########################################
function save_monitor_full_ability()
{
    save_file="${1}"
    monitor_full_ability=$(read_monitor_full_ability "${TMP_PATH}/product_${PRODUCT_NAME}.json")
    LOG "INFO" "save_monitor_full_ability,monitor_full_ability:${monitor_full_ability}"
    if [ -n "${monitor_full_ability}" ]
    then
        sed -i '/^monitor_full_ability=/d' ${save_file}
        echo "monitor_full_ability=${monitor_full_ability}" >>${save_file}
    fi
    return 0
}

##########################################
#  ǰkmcԿл״̬
#  1. /opt/oss/manager/etc/cipher/cloudsop_cipher_mode.flagCloudSopģʽ
#  2. û/opt/oss/manager/etc/cipher/cloudsop_cipher_mode.flagû/opt/oss/manager/etc/cipher/masterCloudSopģʽ
#  3. KMCģʽ
##########################################
function save_kmc_mode()
{
    save_file="${1}"

    # 鱾ڵCloudSopģʽ,ļΪcloudsopģʽ
    [ -f "/opt/oss/manager/etc/cipher/cloudsop_cipher_mode.flag" ]
    result_1="$?"

    [ ! -f "/opt/oss/manager/etc/cipher/cloudsop_cipher_mode.flag" -a ! -d "/opt/oss/manager/etc/cipher/master" ]
    result_2="$?"

    # R19汾KMC,R19汾cloudsopģʽ־ļkmcģʽ־ļһ,ɿ
    [ "${result_1}" -eq 0 -o "${result_2}" -eq 0 ] && kmc_mode_manager="false" || kmc_mode_manager="true"

    LOG "INFO" "save_kmc_mode,kmc_mode_manager:${kmc_mode_manager}"
    # ƽ̨ ȷKMCģʽΪȫϵͳͳһ,ֹҵһKMC,һCloudSop,˴0ŽڵΪж
    sed -i '/^kmc_mode_manager=/d' ${save_file}
    echo "kmc_mode_manager=${kmc_mode_manager}" >>${save_file}
    return 0
}

##########################################
#  ǰϢ
##########################################
function save_pre_config()
{
    save_file="${1}"

    # ʼļ
    if [ ! -f "${save_file}" ]
    then
        touch ${save_file}
    fi

    #  DFSؼֶ״̬"monitor_full_ability" -> "1"
    save_monitor_full_ability ${save_file} || return 1

    #  ǰļģʽ: kmc_mode
    save_kmc_mode ${save_file} || return 1

    # Ĭ˳ 0
    return 0
}

##########################################
#  ǰϢ
##########################################
function backup_pre_config()
{
    # ʱĿ¼
    mkdir -p ${TMP_PATH}

    # ossadm: ·
    CONFIG_PATH="${WORK_PATH}/${UPGRADE_PATH}/workpath-${PRODUCT_NAME}/pre_upgrade"
    LOG_PRINT "INFO" "Start to initialize the directory:${CONFIG_PATH}"
    if [ ! -d "${CONFIG_PATH}" ]
    then
        mkdir -p ${CONFIG_PATH}
    fi
    LOG_PRINT "INFO" "Finished to initialize the directory:${CONFIG_PATH}"

    # ļ
    config_file="${CONFIG_PATH}/pre_upgrade_config.properties"

    # ѯ product_NCE.json
    query_product "${TMP_PATH}" "${PRODUCT_NAME}" || return 1

    # 
    save_pre_config ${config_file} || return 1

    # ˳ʱĿ¼
    rm -rf ${TMP_PATH}

    # ˳
    return 0
}

##########################################
#  
##########################################
function main()
{
    # عģ
    source $(dirname ${SCRIPT_PATH})/common.sh

    # ִû
    check_ossadm_user || return 1

    # ʼ
    initial_params "${INPUT_FILE}" || return 1

    # ƽ̨
    source /opt/oss/manager/bin/engr_profile.sh

    # ǰ
    backup_pre_config || return 1

    # Ĭ˳ 0
    return 0
}

main "$@"
exit $?
