import json
import sys
import time

import easyhttputil
import pyzenith
from util import ossext

from commonlog import Logger

# 检查数据库实例角色
QUERY_ROLE_SQL = "SELECT DATABASE_ROLE FROM SYS.DV_DATABASE"
# 检查数据库实例是否在building
QUERY_BUILDING_SQL = "SELECT PEER_HOST,PEER_BUILDING FROM SYS.DV_HA_SYNC_INFO"

LOGGER = Logger().getinstance(sys.argv[0])


def query_zenith_db(product_name):
    """
    查询产品对应的zenith数据库
    :param product_name:
    :return:
    """
    try:
        export_param = {'tenant': product_name, 'userList': ['adminUser', 'dbUser', 'readUser', 'rplUser']}
        http_func = easyhttputil.httppostWithRetry if hasattr(easyhttputil,
                                                              'httppostWithRetry') else easyhttputil.http_post_with_retry
        response = http_func(
            '/rest/plat/deploy-proxy/v1/containerlist/action?action-id=export-containerlist', export_param, retry=3,
            sleep=5)
        json_data = json.loads(response.decode('utf-8'))
        zenith_db_info_map = {}
        for value in json_data.values():
            if value.get("containerType", "").lower() != "zenith":
                continue
            cluster_name = value.get("clusterName")
            db_instance_name = value.get("dbInstanceName")
            read_user = value.get("readUser")
            read_password = value.get("readPassword")
            ip = value.get("ip")
            port = value.get("port")
            if not cluster_name or not db_instance_name or not read_user or not read_password or not ip or not port:
                continue
            zenith_db_info = {
                "dbInstanceName": db_instance_name,
                "readUser": read_user,
                "readPassword": read_password,
                "ip": ip,
                "port": port
            }
            zenith_db_info_list = zenith_db_info_map.get(cluster_name, [])
            zenith_db_info_list.append(zenith_db_info)
            zenith_db_info_map[cluster_name] = zenith_db_info_list
        return zenith_db_info_map
    except Exception as e:
        LOGGER.error("[query_zenith_db] Exception: %s." % str(e))
        return {}


def query_status(ip, user, pwd, port, peer_ip):
    """
    执行SQL语句查询是
    :param user:
    :param pwd:
    :param port:
    :param ip:
    :return:
    """
    if ":" in ip:
        ip = "[" + ip + "]"
    try:
        pwd_real = ossext.Cipher.decrypt(pwd)
        conn = pyzenith.connect(host=ip, user=user, passwd=pwd_real, port=str(port), sockettimeout=10, logintimeout=10)
        # 创建cursor
        c = conn.cursor()
        # 执行sql语句
        c.execute(QUERY_ROLE_SQL)
        # 调用fetchall方法获取所有结果
        result = c.fetchall()

        role = ''
        is_building = ''
        if result:
            for row in result:
                role = row[0].upper()
        if role == 'PRIMARY':
            c.execute(QUERY_BUILDING_SQL)
            result = c.fetchall()
            is_building = get_is_building(result, peer_ip)
        # 关闭cursor
        c.close()
        # 关闭数据库连接
        conn.close()
        return role, is_building
    except Exception as e:
        LOGGER.error("[query_status] Exception: %s." % str(e))
        return '', ''


def get_is_building(result, peer_ip):
    is_building = ''
    if result:
        for row in result:
            if row[0] == peer_ip:
                is_building = row[1].upper()
    return is_building


def check_roles(zenith_db_map):
    right_num = 0
    wait_num = 0
    building_num = 0
    unexpected_num = 0
    for cluster_name in zenith_db_map.keys():
        zenith_db_infos = zenith_db_map.get(cluster_name, [])
        if len(zenith_db_infos) != 2:
            unexpected_num += 1
            continue
        role1, is_building1 = query_status(zenith_db_infos[0].get("ip"), zenith_db_infos[0].get("readUser"),
                                           zenith_db_infos[0].get("readPassword"), zenith_db_infos[0].get("port"),
                                           zenith_db_infos[1].get("ip"))
        role2, is_building2 = query_status(zenith_db_infos[1].get("ip"), zenith_db_infos[1].get("readUser"),
                                           zenith_db_infos[1].get("readPassword"), zenith_db_infos[1].get("port"),
                                           zenith_db_infos[0].get("ip"))
        LOGGER.info(f"cluster_name={cluster_name} role1={role1} is_building1={is_building1}, "
                    f"role2={role2} is_building2={is_building2}")
        # 主+备代表角色已经恢复正常
        if (role1 == 'PRIMARY' and role2 == 'PHYSICAL_STANDBY') or (role2 == 'PRIMARY' and role1 == 'PHYSICAL_STANDBY'):
            right_num += 1
        # 主+级联备代表角色等待自动修复
        elif (role1 == 'PRIMARY' and role2 == 'CASCADED_PHYSICAL_STANDBY') or (
                role2 == 'PRIMARY' and role1 == 'CASCADED_PHYSICAL_STANDBY'):
            wait_num += 1
        # 主+对端building代表已经出发出发修复
        elif (role1 == 'PRIMARY' and is_building1 == 'TRUE') or (role2 == 'PRIMARY' and is_building2 == 'TRUE'):
            building_num += 1
        else:
            LOGGER.info(
                f"unexpected status:role1={role1} is_building1={is_building1}, role2={role2} is_building2={is_building2}")
            unexpected_num += 1
    return right_num, wait_num, building_num, unexpected_num


def main(argv):
    product_name = argv[1]
    LOGGER.info(f"product_name is:{product_name}")
    zenith_db_map = query_zenith_db(product_name)
    if not zenith_db_map:
        LOGGER.info(f"There are no active and standby instances, and no processing is required")
        return
    LOGGER.info(f"[{product_name}]zenith_db: {[key for key in zenith_db_map.keys()]}")
    retry_count = 0
    unexpected_state_num = 0
    while retry_count < 360:
        time.sleep(10)
        retry_count += 1
        right_num, wait_num, building_num, unexpected_num = check_roles(zenith_db_map)
        if unexpected_num != 0:
            unexpected_state_num += 1
        else:
            unexpected_state_num = 0
        # 所有状态恢复正常后不在循环查询直接退出
        if right_num == len(zenith_db_map):
            LOGGER.info(f"The status of all database instances is normal")
            break
        if wait_num != 0 or building_num != 0:
            LOGGER.info(f"[{product_name}]building_db nums: {building_num}, wait for automatic repair num: {wait_num}")
            continue
        if unexpected_state_num == 3:
            LOGGER.error(f"[{product_name}]The unexpected state occurs three times, ")
            break
    return


if __name__ == "__main__":
    main(sys.argv)
