# encoding=utf-8
"""
功 能：查询产品信息
版权信息：华为技术有限公司，版本所有(C) 2020-2029
修改记录：2020-10-29 21:38 创建
"""
import os
import sys
import json

OSS_ROOT = os.popen("echo $OSS_ROOT").read().strip()

def get_product_list():
    """
    功能描述：获取产品名列表
    修改记录：新增方法
    """
    product_list = []
    manager_nodes_file = "%s/etc/sysconf/nodelists.json" % OSS_ROOT
    with open(manager_nodes_file, 'r') as file_obj:
        json_data = json.load(file_obj)
        for node in json_data.get("nodeList").values():
            product_name = node.get("assignedToTenancy")
            if product_name not in product_list and product_name != "manager":
                product_list.append(product_name)
    products = ""
    for product in product_list:
        products = "%s,%s" % (products, product)
    return "%s|%d" % (products.strip(","), len(product_list))

def main(argv):
    if argv[1] == "get_product_list":
        print(get_product_list())
        return 0
    return 1

if __name__ == '__main__':
    main(sys.argv)