#!/bin/bash
# EasySuite自升级后置脚本,兼容R21C00B050,企业分析发布版本,不支持单独升级EasySuite,必须二次加载Solution
# 兼容方案:重新加载EasySuite,重新进行数据迁移和Solution加载

# 新版本ESSolution包名
ES_SOLUTION=""

#############################################################################
# 功能说明:查询EasySuite包信息,仅适用于R21C00线上场景
#############################################################################
function find_es_pkg()
{
    local old_es_path="${1}"
    # 全局变量 ES_PKG:EasySuite包名,从数据库中查询最新处于部署态的EasySuite包名
    ES_PKG=$(sqlite3 ${old_es_path}/easysuite/db/easysuite.sqlite3 <<END
select pkg_name from es_upgrade_package_detail where pkg_name like '%EasySuite%' and status='running' and progress=86 and task_id=(select task_id from es_upgrade_package_detail where status='running' and progress=86 order by task_id desc limit 1) limit 1;
END
)
}

#############################################################################
# 功能说明:查询Solution包,仅适用于R21C00线上场景
#############################################################################
function find_solution_pkg()
{
    local old_es_path="${1}"
    # 全局变量 ES_SOLUTION:Solution包名
    ES_SOLUTION=$(sqlite3 ${old_es_path}/easysuite/db/easysuite.sqlite3 <<END
select pkg_name from es_upgrade_package_detail where pkg_name like '%Solution%' and status='finish' and task_id=(select task_id from es_upgrade_package_detail where status='running' and progress=86 order by task_id desc limit 1) limit 1;
END
)
}

##################################################
# 功能说明:兼容处理老版本BUG,重新部署加载Solution
##################################################
function fix_r21c00_b050()
{
    local old_es_path="${1}"
    local new_es_path="${2}"
    # 获取待部署的版本EasySuite包名
    find_es_pkg "${old_es_path}"
    [ -z "${ES_PKG}" ] && return 1

    # 获取待部署的版本Solution
    find_solution_pkg "${old_es_path}"

    # 无Solution无需进行重新部署
    [ -z "${ES_SOLUTION}" ] && return 0

    # 备份esadmin_private.key
    cp -fp "${new_es_path}"/var/.easysuite/esadmin_private.key "${old_es_path}"/var/temp/

    # 备份迁移后的数据库
    cp -fp "${new_es_path}"/easysuite/db/easysuite.sqlite3 "${old_es_path}"/var/temp/

    # 给写权限保证可删除
    chmod -R u+w "${new_es_path}"
    # 删除老版本EasySuite
    rm -rf "${new_es_path}/*" &>/dev/null
    # 重新解压EasySuite
    unzip -oq "${old_es_path}"/var/software/"${ES_PKG}" -d "${new_es_path}/"

    # 拷贝Solution到新版本目录下
    cp -fp "${old_es_path}"/var/software/${ES_SOLUTION}* "${new_es_path}/"

    # 恢复数据库和密钥
    mv "${old_es_path}"/var/temp/esadmin_private.key "${new_es_path}"/var/.easysuite/
    mv "${old_es_path}"/var/temp/easysuite.sqlite3 "${new_es_path}"/easysuite/db/
}

##################################################
# 功能说明:执行兼容r21c00升级路径
##################################################
function execute_r21c00()
{
    local old_es_path="${1}"
    local new_es_path="${2}"
    # EasySuite版本号
    local es_version="${3}"

    # 拷贝老版本r21c00的admin_private.key为esadmin_private.key
    cp -fp "${old_es_path}"/var/.easysuite/admin_private.key "${new_es_path}"/var/.easysuite/
    mv "${new_es_path}"/var/.easysuite/admin_private.key "${new_es_path}"/var/.easysuite/esadmin_private.key

    # 更新老版本easysuite登录用户名
    sqlite3 "${new_es_path}"/easysuite/db/easysuite.sqlite3 << END
UPDATE auth_user SET username = 'esadmin' WHERE id = 1;
END

    # ES升级后将任务状态置为initial
    sqlite3 "${new_es_path}"/easysuite/db/easysuite.sqlite3 <<END
UPDATE task_main SET status='Initial' WHERE id=(select task_id from es_upgrade_package_detail where status='running' and progress=86 order by task_id desc limit 1);
END

    if [ "${es_version}" == "21.00.1" ]
    then
        # 21.00.1对应R21C00B050存在已知BUG需要修复
        fix_r21c00_b050 "${old_es_path}" "${new_es_path}" || return 1
    fi
    return 0
}
