#!/bin/bash
# EasySuite自升级后置脚本,兼容R21C00 & R21C10 & R22C00
# R21C00 使用EasySuite进行升级和部署,调用新版本EasySuite部署脚本
# R21C10 使用管理面微服务进行升级部署,使用的微服务内部脚本
# R22C00 管理面微服务部署,调用多一个新版本EasySuite工作路径参数

# 脚本目录
SCRIPT_PATH=$(cd $(dirname $0);pwd)

##################################################
# 功能说明:停止老版本EasySuite进程
##################################################
function stop_old_es()
{
    local old_es_path="${1}"
    LOG "INFO" "Start to stop old easysuite process"
    bash ${old_es_path}/stop.sh &>/dev/null
    # 轮询300秒 等待19090端口释放
    for i in {0..300}
    do
        netstat -anp 2>/dev/null | grep "tcp.*19090.*LISTEN" || break
        sleep 1
    done
    LOG "INFO" "Finished to stop old easysuite process"
}

##################################################
# 功能说明:主入口
##################################################
function main()
{
    # 加载公共方法
    source ${SCRIPT_PATH}/easysuite_upgrade_scripts/common.sh
    # 检查登录用户
    check_user || return 1

    # 解析参数
    current_es_path="${1}"
    # 兼容新老版本,获取EasySuite新版本工作路径
    [ -z "${current_es_path}" ] && current_es_path="$(cd ../../../../../../..;pwd)"
    # 获取EasySuite旧版本工作路径
    old_es_path=$(readlink -f "${ES_WORK_PATH}/easysuite")

    # 获取EasySuite版本号
    es_version=$(cat "${old_es_path}/easysuite/software_define.yaml" | grep 'pkg_version' | awk -F: '{print $NF}' | awk -F. '{print $1"."$2"."$3}')
    rc_version=$(echo ${es_version} | awk -F. '{print $1"."$2}')

    # 记录执行过程版本信息方便定位
    LOG "INFO" "es_version:${es_version};rc_version:${rc_version}"

    if [ "${rc_version}" == "21.00" ]
    then
        source ${SCRIPT_PATH}/easysuite_upgrade_scripts/es_up_start_r21c00.sh
        execute_r21c00 ${old_es_path} ${current_es_path} ${es_version} &>>"${LOG_FILE}"
    else
        cp -fp "${old_es_path}"/var/.easysuite/esadmin_private.key "${current_es_path}"/var/.easysuite/esadmin_private.key
    fi
    
    # 删除软链接
    rm -f /opt/oss/easysuite/easysuite &>>"${LOG_FILE}"
    # 创建软连接
    ln -s ${current_es_path} /opt/oss/easysuite/easysuite &>>"${LOG_FILE}"

    # 停止老版本EasySuite前生成自升级标志文件(兼容21.0在管理面手工启动的场景)
    LOG "INFO" "Generate es_up.flag"
    touch /opt/oss/easysuite/easysuite/es_up.flag &>>"${LOG_FILE}"

    # 停止老版本EasySuite进程避免新版本EasySuite进程假启动
    stop_old_es ${old_es_path} &>>"${LOG_FILE}"
    # 启动EasySuite
    cd /opt/oss/easysuite/easysuite;bash start.sh &>>"${LOG_FILE}"

    # 清理过期版本
    delete_expire_es &>>"${LOG_FILE}"
}


main "$@"
exit $?
