#!/bin/bash

check_hadoop_configured()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking the HADOOP_HOME configuration."

    checkHadoop
    if [[ $? -ne 0 ]]
    then 
        fn_sys_log_error "${host_ip}: The 'HADOOP_HOME' is configured, and other Hadoop platforms may have been installed."
    fi
    fn_sys_log_info "${host_ip}: Success checking the HADOOP_HOME configuration."
}

checkHadoop()
{
    # 检查HADOOP_HOME值是否为空判断是否已安装其他HADOOP
    if [[ -n "${HADOOP_HOME}" ]]; then
        fn_sys_log_error "${host_ip}: The 'HADOOP_HOME' is configured:${HADOOP_HOME}."
        return 1
    fi
    
    return 0
}
