#!/bin/bash

function check_hostname()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking hostname in shell."
    flag=0
    #Զĵǰshellлȡhostname
    hostNameToCheck=$(hostname)

    # hostnameʽ
    formatCheck=$(echo ${hostNameToCheck} | egrep "^[a-zA-Z0-9]([-a-zA-Z0-9]*[a-zA-Z0-9])*$")
    if [[ -z "${formatCheck}" ]]
    then
        fn_sys_log_error "${host_ip}: hostname '${hostNameToCheck}' format error, correct format is '^[a-zA-Z0-9]([-a-zA-Z0-9]*[a-zA-Z0-9])*\$'"
    fi

    formatCheck=$(echo ${hostNameToCheck} | egrep ^"[[:digit:]]+$")
    if [[ -n "${formatCheck}" ]]; then
        fn_sys_log_error "${host_ip}: The hostname cannot contain only digits."
    fi

    fn_sys_log_info "${host_ip}: start checking hostname in config file."

    #Զļлȡhostname
    if [[ -f /etc/sysconfig/network ]]
    then
        hostnameFile=/etc/sysconfig/network
        hostName_hosts=$(cat ${hostnameFile} | grep "HOSTNAME" | grep -vw "^[[:space:]]*#[[:space:]]*HOSTNAME" | grep "${hostNameToCheck}")
        
    elif [[ -f /etc/HOSTNAME ]]
    then
        hostnameFile=/etc/HOSTNAME
        hostName_hosts=$(cat ${hostnameFile} | grep -vw "^[[:space:]]*#*" | grep "${hostNameToCheck}")
    fi

    if [[ -f "/etc/redhat-release" ]]; then
        cat "/etc/redhat-release" | grep "release 7" > /dev/null 2>&1
        if [[ $? -eq 0 ]]; then
            hostnameFile=/etc/hostname
            hostName_hosts=$(cat ${hostnameFile} | grep -vw "^[[:space:]]*#*" | grep "${hostNameToCheck}")
        fi
    fi

    which hostnamectl > /dev/null 2>&1
    if [[ $? -eq 0 ]]; then
        which hostname > /dev/null 2>&1
        if [[ $? -eq 0 ]]; then
           hostnameFile=/etc/hostname
           hostName_hosts=$(cat ${hostnameFile} | grep -vw "^[[:space:]]*#*" | grep "${hostNameToCheck}")
        fi
    fi
    
    if [[ -z "${hostName_hosts}" ]]
    then
        fn_sys_log_error "${host_ip}: the hostname in ${hostnameFile} does not match ${hostNameToCheck}."
    fi

    fn_sys_log_info "${host_ip}: Success checking hostname in shell."
}