#!/bin/bash

function checkKernel()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking kernel."
     #ǰֵ֧kernel
     kernel_notsupport="3.0.101-0.40-default"
     len=$(expr length "${kernel_notsupport}")
  
    #susentp
    IS_SUSE_OS="$(cat /proc/version | grep "SUSE")"
    if [[ -n "$IS_SUSE_OS" ]]; then
        #ϵͳkernel
        kernel_os=$(echo $(uname -r) | cut -c -${len})
        if [[ x"${kernel_notsupport}" = x"${kernel_os}" ]]; then
            fn_sys_log_error "${host_ip}: The Linux kernel version $(uname -r) is not supported."
        fi
    fi
    fn_sys_log_info "${host_ip}: Success checking kernel."
}
