#!/bin/bash


function check_lib64()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking lib64."

    #检查/usr/lib64文件夹下是否存在libhadoop.so文件
    dirPath=/usr/lib64
    if [[ -d "${dirPath}" ]]
    then
        retVal=$(find "${dirPath}" -name "libhadoop*" | wc -l)
        if [[ "${retVal}" -ne 0 ]]
        then
            fn_sys_log_error "${host_ip}: The file 'libhadoop.so' exists in '/usr/lib64'."
        fi
    fi
    fn_sys_log_info "${host_ip}: Success checking lib64."
}
