#!/bin/bash
check_sudoers()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: Start checking the 'Defaults requiretty'"

    checkDefaultsrequiretty
    if [[ $? -ne 0 ]]
    then 
        fn_sys_log_error "${host_ip}: 'Defaults requiretty' is configured incorrectly in '/etc/sudoers' the file."
    fi
    fn_sys_log_info "${host_ip}: Success checking the 'Defaults requiretty'"
    
}

checkDefaultsrequiretty()
{
    result=0
    #检查/etc/sudoers中是否配置Defaults requiretty
    checkResult=$(cat /etc/sudoers  |grep "^Defaults *requiretty")
    if [[ -n "${checkResult}" ]]
    then
        fn_sys_log_error "${host_ip}: '${checkResult}' is configured in '/etc/sudoers' the file."
        result=1
    fi
    #检查/etc/sudoers中是否配置Defaults:xxx !requiretty
    checkResult=$(cat /etc/sudoers  |grep "^Defaults *:.* \!requiretty")
    if [[ -n "${checkResult}" ]];then
        fn_sys_log_error "${host_ip}: '${checkResult}' is configured in '/etc/sudoers' the file."
        result=1
    fi
    
    return ${result}
}


