#!/usr/bin/env bash


###################################################
#
# 参数个数校验
#
###################################################
function source_check_items()
{
    for check_item in $(ls $(dirname "$0")/check_items/ | grep '.sh')
    do
        source $(dirname "$0")/check_items/"${check_item}"    > /dev/null 2>&1
    done
}

###############################################################################################
function fn_get_log_file_path()
{
    echo "${c_root_path}/../../${local_ip}_cmd.process_launch.log"
    return 0
}
function fn_get_all_log_file_path()
{
    echo "${c_root_path}/../../${local_ip}_cmd.process_launch_all.log"
    return 0
}

###############################################################################################
function fn_init()
{
    readonly c_root_path=$(dirname $(readlink -f $0 ))

    # Loading Modules
    source ${c_root_path}/../utils/load_all_util.sh
    source_check_items

    # Initialization Log
    fn_sys_set_logging_verbose "$SYS_LOGGING_INFO"
    fn_check_param_count "$@" || return 1
    readonly local_ip=${1}
    [[ "$(fn_sys_is_valid_ip ${local_ip})" == "false" ]] && fn_sys_log_error "Token [${local_ip}] is not a valid ip" && return 1
    readonly c_log_file="$(fn_get_log_file_path)"

    readonly all_log_file="$(fn_get_all_log_file_path)"
    fn_sys_create_log_file "$all_log_file"
    [ -f "${c_log_file}" ]  && cat "${c_log_file}" >> ${all_log_file}

    [[ -f ${c_log_file} ]] && rm -f ${c_log_file}
    fn_sys_create_log_file "$c_log_file"
    fn_sys_set_log_file "$c_log_file"

    # Parameter initialization
    scene="install"
    declare -r MIN_IP_LOCAL_PORT_ID=32768          #OS随机端口范围的最小值，小于此值可能会与FI所使用端口冲突
    readonly flag_path="/tmp/hd_check_flag"
    complete_flag="${c_root_path}/complete_flag_local_launch"
    c_nodelists_path="/opt/oss/manager/etc/sysconf/nodelists.json"
    c_old_fi_path="/opt/huawei/Bigdata/"
    readonly c_config_path="${c_root_path}/../../conf/fi_cluster_check.conf"
    readonly c_ficluster_tar_path="/tmp/ficluster_conf.json"
    readonly c_ficluster_conf_path="${c_root_path}/../../conf/ficluster_conf.json"
    readonly c_need_check="need_check"    # 白名单标志

    return 0
}

###################################################
#
# 参数个数校验
#
###################################################
function fn_check_param_count()
{
    [[ $# != 1 ]] && fn_sys_log_info "Parameter incorrect." && return 1
    return 0
}

###################################################
#
# 通过白名单过滤执行检查项
#
###################################################
function fn_check_items()
{
    [[ -f "${c_nodelists_path}" ]] && scene="scale"
    [[ -d "${c_old_fi_path}" ]] && scene="upgrade"
    fn_sys_log_info "${scene}"
    for line in $(cat "${c_root_path}/../../conf/sence/${scene}.conf" |sed 's/\r//g' |sed 's/ //g')
    do
        local l_is_need_check="false"
        for need_check in $(cat "${c_config_path}" |sed 's/\r//g' |sed 's/ //g' | grep "${c_need_check}" | awk -F'=' '{print $NF}' | awk -F"," '{ for(i=1; i<=NF; i++) print $i }'); do
            [[ "${line}" == "${need_check}" ]] && l_is_need_check="true" && break
        done
        [[ "${l_is_need_check}" == "true" ]] && fn_sys_log_info "Start to exec ${line}." && ${line} ${local_ip}
    done &
    wait
}

###################################################
#
# 执行检查项
#
###################################################
function fn_create_flag()
{
    touch ${flag_path}
}

###################################################
#
# 执行检查项
#
###################################################
function fn_check_base_items()
{
    [[ -d "${c_old_fi_path}" ]] && scene="upgrade" && return 0
    # 检查OS版本是否支持
    check_os "${local_ip}"
    if [[ $? -ne 0 ]]; then
       exit 255
    fi

    # 检查OS内核版本是否支持
    checkKernel "${local_ip}"
    if [[ $? -ne 0 ]]; then
       exit 255
    fi

    return 0
}

###############################################################################################
function fn_precheck()
{
    fn_sys_log_info "Precheck before pre-installation check."
    fn_sys_assert_current_user_matched "root" || return 1
    fn_sys_assert_not_null "c_config_path" || return 1
    fn_sys_assert_is_file "c_config_path" || return 1

    return 0
}

###############################################################################################
function fn_prepare()
{
    rm -f ${flag_path}
    rm -f ${c_ficluster_tar_path}
    return 0
}

###############################################################################################
function fn_do()
{
    fn_precheck || return 1
    fn_prepare || return 1
    fn_check_base_items || return 1
    fn_check_items || return 1
    [[ ! -f ${c_ficluster_conf_path} ]] && fn_sys_log_error "No such file :${c_ficluster_conf_path}." && fn_create_flag && return 1
    cp ${c_ficluster_conf_path} ${c_ficluster_tar_path} && chown 3004:2000 ${c_ficluster_tar_path} && chmod 640 ${c_ficluster_tar_path}
    fn_create_flag
    return 0
}

###############################################################################################
function fn_main()
{
    readonly c_start_time="$(date +%s)"
    fn_init "$@"
    fn_sys_log_info "Enter post_install"
    fn_do
    local l_result="$?"
    local l_elapsed_seconds="$(fn_sys_get_elapsed_time "$c_start_time")"
    fn_sys_log_info "Leave post_install with status [${l_result}]. It takes [${l_elapsed_seconds}] seconds"
    [[ ${l_result} -ne 0 ]] && fn_sys_log_error "Failed to run check scripts."
    return "$l_result"
}

###############################################################################################
fn_main "$@"
result="$?"
exit "$result"
