#!/bin/bash
#
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
#

###################################################################################
# 执行节点： 各FI节点
# 执行依赖： 无
# 参数：
#     无
# 执行打印：
#     打印需要备份的空间大小统计
###################################################################################

function fn_log_screen() {
    local log_level="$1"
    local l_message="$2"
    echo "[$(date -d today +"%Y-%m-%d %H:%M:%S")][${log_level}] ${l_message}"
}

function check_metadata_space() {
    local meta_dirs=("/srv/BigData/journalnode" "/srv/BigData/ldapData" "/srv/BigData/namenode" "/srv/BigData/tmp" "/srv/BigData/zookeeper" "/srv/BigData/redis" )
    local meta_size=0
    for dir in "${meta_dirs[@]}"; do
        if [[ -d "$dir" ]]; then
            local size=$(du -sm "$dir" | awk '{print $1}')
            local meta_size=$((meta_size + size))
            fn_log_screen "INFO" "'$dir' = $size M"
        fi
    done
    fn_log_screen "INFO" "Total MetadataFile=$meta_size M"
    return 0
}

check_metadata_space
exit $?
