#!/bin/bash -

###############################################################################################
#
# 清理残留进程
#
###############################################################################################
function fn_kill_useless_ndp_process()
{
    fn_sys_log_info "Start to delete unnecessary processes in the environment."
    ps -efww | grep -v "grep" | grep "Product-NdpDataNodeService\|Product-NdpDiagnosService\|Product-NdpJournalNodeService\|Product-NdpKafkaService\|Product-NdpKerberosService\|Product-NdpLdapService\|Product-NdpMetaStoreService\|Product-NdpNameNodeService\|Product-NdpNodeManagerService\|Product-NdpRedisService\|Product-NdpResourceManagerService\|Product-NdpSparkHistoryService\|Product-NdpSparkThriftService\|Product-NdpStatusService\|Product-NdpToolService\|Product-NdpUIHomeWebsite\|Product-NdpZkfcService\|Product-NdpZooKeeperService\|Product-NdpHBaseMasterService\|Product-NdpHBaseRegionService" | awk '{print $2}' | xargs -i kill -9 {}
    fn_sys_log_info "End to delete unnecessary processes in the environment."

    return 0
}

###############################################################################################
#
# 清理残留标记文件
#
###############################################################################################
function fn_clear_step_flag()
{
    fn_sys_log_info "Start to clear the remaining upgrade step flag files in the environment."
    rm -f ${g_process_upgrade_flag}
    rm -f ${g_process_rollback_flag}
    rm -f ${g_process_confirm_flag}
    rm -f ${g_process_kafka_backup_flag}
    fn_sys_log_info "End to clear the remaining upgrade step flag files in the environment."

    return 0
}

###############################################################################################
function fn_kill()
{
    fn_sys_log_info "Start to kill cgroup process."
    local l_subsystem_path="$1"

    local readonly c_cgroup_procs="cgroup.procs"
    find "$l_subsystem_path" -mindepth 1 -type d | sort -r | xargs -i cat {}/${c_cgroup_procs} | xargs -i kill -9 {}
    sleep 2

    local l_process_count=$(find "$l_subsystem_path" -mindepth 1 -type d | xargs -i cat {}/${c_cgroup_procs} | wc -l)
    [ "$l_process_count" -ne "0" ] && fn_sys_log_error "Active process found after killing" && return 1

    fn_sys_log_info "No active process found after killing."
    return 0
}

###############################################################################################
function fn_kill_cgroup_procs()
{
    fn_sys_log_info "Start to clear cgroup process."
    local l_subsystem_path="/sys/fs/cgroup/cpu,cpuacct/hadoop-yarn"

    local readonly c_max_retry_round=100
    local readonly c_retry_interval=1

    local l_finished="false"
    for((l_retry_round=1; l_retry_round<=c_max_retry_round; l_retry_round++)); do
        fn_sys_log_info "Retry round [${l_retry_round}]: Killing cgroup process for [${l_subsystem_path}] ..."
        fn_kill "$l_subsystem_path"
        if [ "$?" -eq "0" ]; then
            fn_sys_log_info "Retry round [${l_retry_round}]: Killing cgroup process for [${l_subsystem_path}] ... Done"
            l_finished="true"
            break
        else
            fn_sys_log_warn "Retry round [${l_retry_round}]: Killing cgroup process for [${l_subsystem_path}] ... Failed"
            sleep "$c_retry_interval"
        fi
    done
    [ "$l_finished" == "false" ] && fn_sys_log_error "After all retry round [${c_max_retry_round}], cgroup process are not killed" && return 1

    return 0
}