#!/bin/bash -

###############################################################################################
function fn_sys_execute_cmd()
{
    fn_sys_log_debug "Executing Command <$@> ..."
    $@
    local l_result="$?"
    [ "$l_result" -ne "0" ] && fn_sys_log_error "Executing Command <$@> ... Failed" && return "$l_result"
    fn_sys_log_debug "Executing Command <$@> ... Done"

    return 0
}

###############################################################################################
function fn_sys_execute_cat_to()
{
    local l_source_file="$1"
    local l_dest_file="$2"

    fn_sys_log_debug "Executing Command <cat ${l_source_file} > ${l_dest_file}> ..."
    cat "$l_source_file" > "$l_dest_file"
    [ "$?" -ne "0" ] && fn_sys_log_error "Executing Command <cat ${l_source_file} > ${l_dest_file}> ... Failed" && return 1
    fn_sys_log_debug "Executing Command <cat ${l_source_file} > ${l_dest_file}> ... Done"

    return 0
}
