#!/usr/bin/env bash

###############################################################################################
function fn_get_log_file_path()
{
    echo "${c_root_path}/cmd.${scene_name}_remote_process.log"
    return 0
}

function fn_get_all_log_file_path()
{
    echo "${c_root_path}/cmd.${scene_name}_remote_process_all.log"
    return 0
}

###################################################
#
# 参数个数校验
#
###################################################
function fn_check_param_count()
{
    [[ $# != 1 ]] && fn_sys_log_info "Parameter incorrect." && return 1
    return 0
}

###################################################
#
# 执行远端命令
#
###################################################
function fn_run_command_remote()
{
    fn_sys_log_info "Start executing remote cmds."
    host_ip="$1"
    user="$2"
    passwd="$3"
    command="$4"
    timeout="$5"
    is_log="$6"
    exec_cmd_remote ${host_ip} ${user} "${timeout}" "${command}" ${is_log}<<EOF
${passwd}
EOF
    result=$?
    [[ ${result} -ne 0 ]] && return ${result}
    fn_sys_log_info "Success to execute the remote command." && return 0

}

###################################################
#
# 拉起远端检查
#
###################################################
function fn_invoke_local_upgrade_remote()
{
    fn_sys_log_info "Start to invork local check on remote."
    local flag_path="/tmp/hd_${scene_name}_flag"
    for each_ip in ${fi_ip_list}; do
        fn_sys_log_info "Invoking on node [${each_ip}]"
        fn_run_command_remote "${each_ip}" "root" "${remote_password}" "rm -f ${flag_path};" "10"  0
        nohup ssh -o StrictHostKeyChecking=no root@${each_ip} "sh ${c_path_workspace}/shscript/module/${scene_name}_local_launch.sh" >/dev/null 2>&1 &
        result=$?
        [[ ${result} -ne 0 ]] && fn_sys_log_error "Failed in invoking the script of the remote node [${each_ip}]." && return 1
        fn_sys_log_info "Succeeded in invoking the script of the remote node [${each_ip}]."
    done
    return 0
}

###################################################
#
# 远端检查是否均已结束
#
###################################################
function fn_check_result_remote()
{
    fn_sys_log_info "Start to invork local check on remote."
    local flag_path="/tmp/hd_${scene_name}_flag"
    local l_running_times=0
    local l_max_run_times=1440
    while [ "${l_running_times}" -le "${l_max_run_times}" ]; do
        sleep 5

        fn_sys_log_info "Waiting for task complete: Elapsed time $((l_running_times*5)) Seconds. "
        l_pending_count=0
        for each_ip in ${fi_ip_list}; do
            fn_sys_log_info "Confirm the check result on the remote node [${each_ip}]."
            fn_run_command_remote "${each_ip}" "${g_remote_user}" "${remote_password}" "ls ${flag_path};" "5" 0
            result=$?
            [[ ${result} -ne 0 ]] && l_pending_count=$((l_pending_count+1)) && fn_sys_log_info "Remote node is executing: [${each_ip}]."
        done
        fn_sys_log_warn "[${l_pending_count}] process(es) are still running."
        [ "${l_pending_count}" -eq 0 ] && break
        l_running_times=$((l_running_times+1))
    done
    [[ "${l_running_times}" -le "${l_max_run_times}" ]] && fn_sys_log_info "The check on all nodes is complete." && return 0
    fn_sys_log_error "Check timeout failed and exited."
    return 1
}

###################################################
#
# 适配管控分离场景，推送kafka备份meta数据到kafka部署节点。
#
###################################################
function fn_push_kafka_meta_remote()
{
    [[ ${scene_name} != "upgrade" ]] && return 0
    fn_sys_log_info "Start to pushing kafka data to remote nodes."
    file_path=$(dirname ${tar_kafka_meta_back_file})
    start_index=0
    from_node=""
    for each_ip in ${fi_ip_list}; do
        ((start_index++))
        [[ $start_index -eq 1 ]] && from_node=${each_ip} && continue
        fn_sys_log_info "Start to collect data from [${from_node}] and copy it to [${each_ip}]."
        fn_run_command_remote "${from_node}" "${g_remote_user}" "${remote_password}" "scp -o StrictHostKeyChecking=no ${tar_kafka_meta_back_file} ${each_ip}:${file_path}" "50" 0
        result=$?
        fn_run_command_remote "${each_ip}" "${g_remote_user}" "${remote_password}" "chown ossuser:ossgroup ${tar_kafka_meta_back_file}" "5" 0
        [[ ${result} -ne 0 ]] && fn_sys_log_error "Failed to collect data from [${from_node}] and copy it to [${each_ip}]." && return 1
        fn_sys_log_info "End to collect data from [${from_node}] and copy it to [${each_ip}]."
    done
    fn_sys_log_info "End to pushing kafka data to remote nodes."
    return 0
}


###################################################
#
# 获取所有远程节点上的日志文件，并处理。
#
###################################################
function fn_process_result()
{
    fn_sys_log_info "Obtaining logs from remote nodes."
    for each_ip in ${fi_ip_list}; do
        fn_sys_log_info "${c_path_workspace}/cmd.${scene_name}_local_process.log"
        fn_sys_log_info "${c_root_path}/log/${each_ip}_cmd.${scene_name}_local_process.log"
        [[ "$(fn_cp_file_from_remote ${each_ip} "root" "240" "${c_path_workspace}/cmd.${scene_name}_local_process.log" "${c_root_path}/log/${each_ip}_cmd.${scene_name}_local_process.log" "")" == "false" ]] && fn_sys_log_error "Failed to obtain logs from the node [${remote_node}]." && return 1
    done

    return 0
}

###################################################
#
# 汇总日志文件
#
###################################################
function fn_cp_file_from_remote()
{
    fn_sys_log_info "Copy the log files of other nodes to the current node."
    host_ip="$1"
    user="$2"
    timeout="$3"
    c_src_path="$4"
    c_des_path="$5"
    passwd="$6"
    cp_file_from_remote "${host_ip}" "${user}" "${timeout}" "${c_src_path}" "${c_des_path}" "0" <<EOF
${passwd}
EOF
    result=$?
    [[ ${result} -ne 0 ]] && fn_sys_log_error "Failed to copy files from the remote ${host_ip}." && echo "false" && return 1
    fn_sys_log_info "Success to copy files from the remote ${host_ip}." && echo "true" && return 0
}


###################################################
#
# 解析日志，判断返回正确与否
#
###################################################
function fn_adjust_result()
{
    result=0
    grep -ir "\[ERROR\]" "${c_log_file}" >/dev/null 2>&1;
    [[ $? -eq 0 ]] && result=$((result+1))

    find "${c_root_path}/log/" -name "*cmd.${scene_name}_local_process.log" | xargs -i cat {} | grep "\[ERROR\]" >> "${c_log_file}"
    [[ $? -eq 0 ]] && result=$((result+1))
    return ${result}
}

###############################################################################################
function fn_init()
{
    readonly c_root_path=$(dirname $(readlink -f $0 ))
    source ${c_root_path}/shscript/utils/load_all_util.sh
    fn_sys_set_logging_verbose "$SYS_LOGGING_INFO"
    readonly c_log_file="$(fn_get_log_file_path)"

    # save history log file
    readonly all_log_file="$(fn_get_all_log_file_path)"
    fn_sys_create_log_file "$all_log_file"
    [ -f "${c_log_file}" ]  && cat "${c_log_file}" >> ${all_log_file}

    rm -f "${c_log_file}"
    fn_sys_create_log_file "$c_log_file"
    fn_sys_set_log_file "$c_log_file"
    source "${c_root_path}/shscript/profile/upgrade_profile.sh"
    remote_password=" "
    return 0
}

###############################################################################################
function fn_precheck()
{
    fn_sys_log_info "Precheck before pre-installation check."
    fn_sys_assert_current_user_matched "root" || return 1
    fn_check_param_count "$@" || return 1
    fn_sys_assert_in_range "scene_name" "upgrade,rollback,confirm"
    fn_sys_assert_not_null "g_upgrade_param" || return 1
    fn_sys_assert_is_file "g_upgrade_param" || return 1
    [[ "$(fn_sys_is_valid_ip "${omp_ip}")" == "false" ]] && fn_sys_log_error "The OMP IP address in the configuration file is invalid." && return 1

    return 0
}

###############################################################################################
function fn_do()
{
    fn_sys_log_info "Start the pre-installation check..."
    fn_invoke_local_upgrade_remote || return 1
    fn_check_result_remote || return 1
    fn_push_kafka_meta_remote || return 1
    fn_process_result || return 1

    fn_sys_log_info "Pre-installation check done."
    return 0
}

###############################################################################################
function fn_main()
{

    readonly c_start_time="$(date +%s)"
    scene_name=${1}
    fn_init || return 1
    fn_sys_log_enter
    fn_precheck "$@" || return 1
    fn_do || return 1
    fn_adjust_result

    local l_result="$?"
    local l_elapsed_seconds="$(fn_sys_get_elapsed_time "$c_start_time")"
    fn_sys_log_leave "Result [${l_result}]. It takes [${l_elapsed_seconds}] seconds"
    return "$l_result"
}

###############################################################################################

fn_main "$@"
result="$?"
fn_sys_audit_log "${result}" "Init upgrade" "Execute remote_launch "
exit "${result}"
