#!/usr/bin/env bash
logger  -p local0.info "`who -m | cut -d\( -f2 |cut -d\) -f1`  ${BASH_SOURCE}; start;successfully execute ${BASH_SOURCE}"

FLAG_FILE="/root/EasySuite/[0-9]*/conf/config.properties"
if [[ $# -ne 1 ]]; then
    logger  -p local0.info "`who -m | cut -d\( -f2 |cut -d\) -f1` ${BASH_SOURCE};wrong argument numbers"
    echo RESULT:255
    exit 1
fi
step_name="${1//\./_}"

ps -ef|grep ${1}|grep -v $0|grep -v 'grep'
if [[ $? -eq 0 ]]; then
    logger  -p local0.info "`who -m | cut -d\( -f2 |cut -d\) -f1` ${BASH_SOURCE};command on execution;"
    echo RESULT:1
    exit 0
else
    # 由于此监控脚本的进程和launch.pyc的进程一起被拉起，sleep 2以免python编译器启动延迟增加等待避免ps不到进程直接失败
    sleep 2
    ps -ef|grep ${1}|grep -v $0|grep -v 'grep'
    if [[ $? -eq 0 ]]; then
        logger  -p local0.info "`who -m | cut -d\( -f2 |cut -d\) -f1` ${BASH_SOURCE};command on execution;"
        echo RESULT:1
        exit 0
    fi
fi

grep "${step_name}_flag=0" ${FLAG_FILE}
if [[ $? -eq 0 ]]; then
   echo RESULT:100
   exit 0
fi

echo RESULT:255
logger  -p local0.info "`who -m | cut -d\( -f2 |cut -d\) -f1` ${BASH_SOURCE}; end;successfully execute ${BASH_SOURCE}"