#!/usr/bin/env bash

CURRENT_PATH="$(cd $(dirname $0);pwd)"
# 日志文件路径
LOGFILE=/opt/oss/log/manager/EntEngineeringService/service_restart.log
#*************************************************************#
# Name:        getSysTime                                     #
# Description: get the system time                            #
# Inout:                                                      #
# Ouput:   Time: 2009-11-03 09:09:09                          #
# Date:    2009-11-03                                         #
#*************************************************************#
function fn_getSysTime()
{
    DST=`/usr/bin/python -c "import time;timest = time.localtime();print(timest.tm_isdst)"`
    if [ $DST == '1' ]
    then
        date "+%Y-%m-%d %T DST"
    else
        date "+%Y-%m-%d %T"
    fi
}
################################################################################
# Function: check_ip
# Description: 校验ip
# Parameter:
#   input:
#   N/A
#   output:
#   N/A
# Return: 0 -- success; not 0 -- failure
# Others: N/A
################################################################################
check_ip()
{
    [[ $1 =~ ^([1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([1-9]?[0-9]|1[0-9][0-9]?|2[0-4][0-9]|25[0-5])){3}$ ]]  ||\
    [[ $1 =~ ^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$ ]]
}

check_ipv6()
{
    ipaddr=$1
    matchResult=`echo "$ipaddr" | grep -E "^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$"`
    if [[ "$matchResult" != "$ipaddr" ]];then
        return 1
    fi
    return 0
}
#*************************************************************#
# Name:         LOG                                           #
# Description: record the message into the logfile            #
# Inout:  log message                                         #
# Ouput:                                                      #
# Date:    2009-11-03                                         #
#*************************************************************#
function LOG()
{
    local strTime=`fn_getSysTime`
    local curSize
    local maxSize=1024000
    local maxRecord=3
    local index=2
    local content="$*"

    content=`echo "${content}"`

    if [ -z ${LOGFILE} ]
    then
        echo -e "[${strTime}] ${content}"
    elif [  -f ${LOGFILE} ]
    then
        curSize=`ls -lk ${LOGFILE} | awk -F" " '{print $5}'`
        if [ ${curSize} -ge ${maxSize} ]
        then
            while [ ${index} -gt 0 ]
            do
                if [ -f ${LOGFILE}.${index} ]
                then
                    mv ${LOGFILE}.${index} ${LOGFILE}.`expr ${index} + 1`

                fi
                let index--
            done
            mv ${LOGFILE} ${LOGFILE}.1

            echo >> ${LOGFILE}
        fi
        echo -e  "[${strTime}] ${content}" | tee -a ${LOGFILE}
        sed -i -e "s#[Pp][Aa][Ss][Ss][Ww][Oo][Rr][Dd]#pvalue#g" -e "s#[Pp][Aa][Ss][Ss][Ww][Dd]#pvalue#g" ${LOGFILE}
    else
        mkdir -p `dirname ${LOGFILE}`
        chmod 700 `dirname ${LOGFILE}`
        echo -e "[${strTime}] ${content}" | tee -a ${LOGFILE}
        sed -i -e "s#[Pp][Aa][Ss][Ss][Ww][Oo][Rr][Dd]#pvalue#g" -e "s#[Pp][Aa][Ss][Ss][Ww][Dd]#pvalue#g" ${LOGFILE}
    fi
}

#*************************************************************#
# Name:        WARN                                           #
# Description: record the warning message into the logfile    #
# Inout:  warning message                                     #
# Ouput:                                                      #
# Date:    2009-11-03                                         #
#*************************************************************#
function WARN()
{
    LOG "WARN: $*"
}

#*************************************************************#
# Name:        ERROR                                          #
# Description: record the error message into the logfile      #
# Inout:  error message                                       #
# Ouput:                                                      #
# Date:    2009-11-03                                         #
#*************************************************************#
function ERROR()
{
    LOG "ERROR: $*"
}

# print log function
function PRINT_LOG()
{
    local LOG_LEVEL=$1
    local LOG_INFO=$2

    if [ -z "${LOGFILE}" ]
    then
        LOGFILE="${THELOGFILE}"
    fi

    case ${LOG_LEVEL} in
        "INFO")
            LOG "${LOG_INFO}"
        ;;
        "WARN")
            WARN "${LOG_INFO}"
        ;;
        "FATAL")
            ERROR "${LOG_INFO}"
        ;;
        "ERROR")
            ERROR "${LOG_INFO}"
        ;;
        *)
            WARN " The LOG_LEVEL must be <INFO|WARN|FATAL>, it will be set to WARN by default ..."
            WARN "${LOG_INFO}"
        ;;
    esac
}

# 检查微服务健康状态
check_health()
{
    service_name=$1
    app_path=/opt/oss/${product_name}/apps/${service_name}
    if [[ -d ${app_path} ]];then
        port_file=${app_path}/etc/sysconf/$(ls ${app_path}/etc/sysconf/| grep ${service_name})
        service_port=$(python -c """
import sys,json
with open(sys.argv[1], \"r\") as port_json:
    port_dict = json.load(port_json)
    for key,val in port_dict[\"processes\"].items():
        for inner_key,inner_val in val.items():
            if inner_key == \"local\":
                print(inner_val[\"port\"])
""" ${port_file})
        app_file=${app_path}/pub/app_define.json
        service_health_chk=$(python -c """
import sys,json
with open(sys.argv[1], \"r\") as app_json:
    app_dict = json.load(app_json)
    for key,val in app_dict[\"processes\"].items():
        for inner_key,inner_val in val.items():
            if inner_key == \"healthChk\":
                print(inner_val[\"url\"])
""" ${app_file})
        service_health_chk=$(echo ${service_health_chk} | awk -F'?' '{print $1}')
        if [[ $service_health_chk != "" ]];then
            echo "service has healthcheck"
            su ossadm -c "bash /opt/oss/StartAndStopCheck.sh ${service_health_chk} ${service_port} 127.0.0.1 ${product_name}"
            echo "service end"
        fi
}

check_healthcheck(){
    for i in {1..60}
    do
      hkres=`python -c "import util.httpclient;client=util.httpclient.CommonHttpClient(\"${3}\",${2},True,True);print(client.get(\"${1}?mode=start\"));"`
    if test ${hkres:1:3} -eq 200; then

      return 0
    else
      sleep 1
    fi
    done
}


main()
{
    logger  -p local0.info "`who -m | cut -d\( -f2 |cut -d\) -f1`  ${BASH_SOURCE}; start;successfully execute ${BASH_SOURCE}"
    service_list=$*
    re_flag=0
    product_name=$(ls /opt/oss/log/ | grep -v manager | grep -v NCE)
    for(( i=0;i<${#service_list[@]};i++)) do
        check_health ${service_list[i]} || reflag=1
    done
    return $re_flag
    logger  -p local0.info "`who -m | cut -d\( -f2 |cut -d\) -f1` ${BASH_SOURCE}; end;successfully execute ${BASH_SOURCE}"
}

main $*
exit $?

