#!/bin/bash

SCRIPT_NAME=$(basename $0)

main()
{
    logger  -p local0.info "user: `who -m | cut -d\( -f2 |cut -d\) -f1`, begin to execute ${SCRIPT_NAME},$1"
    ls /lib/modules/*.aarch64/extra | grep mlnx-ofa_kernel
    if [[ $? -ne 0 ]];then
        echo "no mlx driver,no need do anything"
        exit 0
    fi
    cp -r /lib/modules/*.aarch64/extra/mlnx-ofa_kernel /lib/modules/$(uname -r)/extra
    modprobe -r mlx5_ib
    modprobe -r mlx5_core
    modprobe -r ib_uverbs
    depmod -a
    modprobe ib_uverbs
    modprobe mlx5_core
    modprobe mlx5_ib

    echo "Mellanox driver updated successfully"

    service network restart
    logger -p local0.info "$(who -m | cut -d\( -f2 |cut -d\) -f1)  [update_mlx_driver]Mellanox driver updated successfully"
}

main