#!/bin/bash

CUR_PATH=$(cd `dirname $0`;pwd)
CONF_DIR="${CUR_PATH}"/conf
START_LOCK_FLAG=/tmp/start_all.lock
source "${CUR_PATH}"/../shscript/util.sh
# ---------------------------------------------------------------------------- #
#                                                #
# ---------------------------------------------------------------------------- #
start_cluster()
{
    PRINT_LOG INFO "begin to start_cluster"
    cd ${CUR_PATH}/../script
    ${CUR_PATH}/../script/python/bin/python launch.pyc cloud.bg_frame.resolve &
    PID="$!"
    wait "$PID"
    if [[ "$?" != "0" ]];then
        PRINT_LOG INFO "start failed"
        logger -p local0.error "$(who -m | cut -d\( -f2 |cut -d\) -f1);execute start.sh failed."
        return 1
    fi
    if [[ -f ${CONF_DIR}/silent.properties ]];then
        rm -f ${CONF_DIR}/silent.properties
    fi
    if [[ -f ${CUR_PATH}/../conf/silent.properties ]];then
        rm -f ${CUR_PATH}/../conf/silent.properties
    fi
    if [[ -f ${START_LOCK_FLAG} ]];then
        rm -f ${START_LOCK_FLAG}
    fi
    PRINT_LOG INFO "start success"
    return 0
}

init()
{
    > ${CONF_DIR}/silent.properties

}

# ---------------------------------------------------------------------------- #
# ƽ̨ossadm ssh˼ܴҪǰ̺ossadmЧ                         #
# ---------------------------------------------------------------------------- #
startssh()
{
      PRINT_LOG INFO "begin to start ssh-agent"
      su - ossadm -c "source /opt/oss/manager/bin/engr_profile.sh;ipmc_adm -cmd startmgr -app DeployAgent"
      if [[ "$?" != "0" ]];then
              PRINT_LOG INFO "start ssh-agent failed"
              return 1
      fi
      PRINT_LOG INFO "start ssh-agent success"
      return 0
}

main()
{
    logger -p local0.info "$(who -m | cut -d\( -f2 |cut -d\) -f1);execute start.sh starting"
    is_installing "${START_LOCK_FLAG}" || return 1
    init || return 1
    startssh || return 1
    pre_check || return 1
    start_cluster || return 1
    logger -p local0.info "$(who -m | cut -d\( -f2 |cut -d\) -f1);execute start.sh successfully."
}

main $*
exit $?
