#!/usr/bin/env bash
logger  -p local0.info "`who -m | cut -d\( -f2 |cut -d\) -f1`  ${BASH_SOURCE}; start;successfully execute ${BASH_SOURCE}"
UNINSTALL_FLAG=/tmp/stop_all.lock
OSCONFIG_UNINSTALL=/usr/local/osconfig/os/bin/uninstall.sh
################################################################################
# Function: is_running
# Description: 检查是否有多个卸载脚本进程
##################################################################################
is_running(){
    lock_file=$1
    if [[ -f "${lock_file}" ]];then
        pid=$(cat ${lock_file}| grep "pid" | awk -F'=' '{print $2}')
        ps -p ${pid} 2>&1 >/dev/null
        if [[ $? == 0 ]];then
            echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);there is other user running this script, exit."
            return 1
        fi
    fi
    echo "pid=$$" > ${lock_file}
    return 0
}
################################################################################
# Function: uninstall_osconfig
# Description: 卸载osconfig
##################################################################################
function uninstall_osconfig() {
    echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);Start to uninstall osconfig."
    if [ -f ${OSCONFIG_UNINSTALL} ]; then
        su ossadm -c "bash ${OSCONFIG_UNINSTALL}"
        if [[ $? != 0 ]]; then
            echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);Fail to uninstall osconfig."
            exit 1
        fi
    fi
    echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);Success to uninstall osconfig."
}
################################################################################
# Function: delete_user
# Description: 用户卸载
##################################################################################
function delete_user()
{
    echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);Start to delete the user $1."
    cat /etc/passwd | grep -w "$1" >/dev/null
	  if [ $? -ne 0 ]; then
		    echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);There is no user named $1."
	  else
        killall -u $1
        userdel -r -f $1 >/dev/null 2>&1
        if [ $? -eq 0 ]; then
            echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);Success to delete the user $1."
        else
            echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);Failed to delete use $1, it may effect the installation of next time. Delete the user manually, please!"
        fi
	  fi
}
################################################################################
# Function: delete_ntp
# Description: ntp处理，解决安装管理面ntp失败的问题
##################################################################################
function delete_ntp()
{
    echo "delete ntp"
    if [[ -f /etc/chrony.conf ]]
    then
        sed "/^server/d" /etc/chrony.conf >/etc/chrony_tmp.conf
        mv /etc/chrony_tmp.conf /etc/chrony.conf
        chmod 600 /etc/chrony.conf
        systemctl restart chronyd
        echo "delete ntp result: $?"
    fi
}

################################################################################
# Function: delete_fstab_coredump
# Description: 删除/etc/fstab中coredump配置,解决该目录不存在重启os无法挂载进入紧急模式的问题
##################################################################################
delete_fstab_coredump(){
    echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);Start to delete fstab coredump."
    if [[ -f /etc/fstab ]]
    then
        sed -i '/coredump/d' /etc/fstab
        echo "delete fstab codedump: $?"
    fi
    echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);Success to delete fstab coredump."
}


################################################################################
# Function: delete_backup_audit_cron
# Description:
#       删除 /var/log/audit/ 目录下转储和归档的备份目录。
#       回退转储和备份配置
##################################################################################
delete_backup_audit_cron(){
    echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);Start to delete backup audit."
    rm -rf /var/log/audit/backup_*
    sed -i "s/^num_logs.*$/num_logs\ =\ 25/" /etc/audit/auditd.conf
    service auditd restart
    sed -i "/audit_logrotate.sh/d" /etc/crontab
    service cron restart
    echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);Success to delete backup audit."
}

################################################################################
# Function: uninstall_arbitration
# Description: 容灾场景分析器节点卸载仲裁软件,分析器节点最多只装一套仲裁服务，所以索引是0
##################################################################################
uninstall_arbitration() {
    echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);Start to uninstall arbitration."
    if [[ -f /opt/arbitration_file/uninstall_arbitration.sh ]]
    then
        echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);uninstalling arbitration."
        echo "Y"| sh /opt/arbitration_file/uninstall_arbitration.sh 0
        if [[ "$?" != "0" ]]
        then
            echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);uninstall arbitration fail"
            return 1
        fi
        rm -rf /opt/arbitration_file
    fi
    echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);Success to uninstall arbitration."
    return 0
}
is_running "${UNINSTALL_FLAG}" || exit 1
uninstall_arbitration
#先执行卸载FI自研，避免ossuser无法卸载的情况
echo "Start to uninstall the NdpToolService"
su - ossuser -c "source /opt/oss/*/apps/NdpToolService/profile/app_profile.sh;sh /opt/oss/*/apps/NdpToolService/init/uninstall.sh"  > /dev/null
rm -rf /opt/NdpTools > /dev/null 2>&1
echo "End to uninstall the NdpToolService"
#开始卸载产品
UNINSTALL_SCRIPT_PATH=$(cd `dirname $0`; pwd)
cd ${UNINSTALL_SCRIPT_PATH}
"${UNINSTALL_SCRIPT_PATH}/python/bin/python" launch.pyc processor complex.uninstall.uninstallAll
if [[ $? == 0 ]]
then
    #卸载osconfig
    uninstall_osconfig
    #卸载ossadm用户
    delete_user ossadm
    delete_ntp
    delete_fstab_coredump
    delete_backup_audit_cron
    rm -rf ~/.ssh/* /etc/sudoers.d/*_sudoers /tmp/authorized_keys_flag /opt/entTools /opt/coredump /opt/tools /opt/sudobin /opt/backup_cloudsop_tmp /opt/insight_upgrade /opt/os_upgrade /opt/upgrade /opt/upgrade_backup /opt/backuptmp /tmp/flag_restore_repair_node /opt/signtool /opt/SEK;
fi
rm -rf /opt/sudobin /usr/local/osconfig /opt/os_patch /usr/local/os_tool
delete_user secuser
if [[ -f ${UNINSTALL_FLAG} ]];then
    rm -f ${UNINSTALL_FLAG}
fi
echo "$(who -m | cut -d\( -f2 |cut -d\) -f1);uninstall ok"
logger  -p local0.info "`who -m | cut -d\( -f2 |cut -d\) -f1` ${BASH_SOURCE}; end;successfully execute ${BASH_SOURCE}"