#!/bin/bash
################################################################################
## Copyright:   HUAWEI Tech. Co., Ltd.
## Filename:    log.sh
## Description: Log Records
## Version:     CampusInsight V100R21C00
## Created:     Saturday, 4 10, 2021
################################################################################

################################################################################
# Function: syslog
# Description: Important operation must record to syslog
# Parameters :
#   input:
#   $1: message
#   output:
#   N/A
# Return: 0 -- success; not 0 -- failure
# Others: N/A
################################################################################
function syslog()
{
    local message=$1
    which logger >/dev/null 2>&1
    [ "$?" -ne "0" ] && return 0;
    logger -p local0.notice -i "${message}"

}

################################################################################
# Function: main
# Description: Important operation must record to syslog
# Parameters :
#   input:
#   $1: collect_path ; ${@:2:$#-2}: input_param ;  ${@:$#-1:1}: start_time ; ${@: -1}: end_time
#   output:
#   N/A
# Return: 0 -- success; not 0 -- failure
# Others:
#   /opt/oss/share/manager/SMPAgentService/tempDir/task_1617790076383_Analyzer-02(10.136.156.82)
#   -collectType a -collectnum v
#   2021-04-07 13:04:39
#   2021-04-07 17:04:39
################################################################################
function main()
{
    # process the input params
    if [[ $* == *\;* || $* == *\|* || $* == *\&* || $* == *\$*  || $* == *\"*  || $* == *\'* || $* == *\>* || $* == *\<* || $* == *\`*  ]];then
        syslog "The log collection input parameter contains invalid characters."
        exit 1
    fi

    tmp_path=$2

    if [[ ${tmp_path: -1} == / ]];then
        tmp_path=${tmp_path%/*}
    fi

    if [[ -L ${tmp_path} ]];then
        syslog "Log collection input parameters contain soft links."
        exit 1
    fi

    path="/opt/oss/share/manager/SMPAgentService/tempDir"

    if [[ $(dirname ${tmp_path}) != $path ]];then
        syslog "The path contained in the log collection input parameter is not the same as the target path."
        exit 1
    fi
    /opt/entTools/script/python/bin/python /opt/entTools/script/collect_launch.pyc collect_processor $*
}

main $*
