#!/bin/bash
declare -r LOG_FILE=/var/log/insight/install/install.log

function main()
{
    # process the input params
    if [[ $* == *\;* || $* == *\|* || $* == *\&* || $* == *\$*  || $* == *\"*  || $* == *\'* || $* == *\>* || $* == *\<* || $* == *\`*  ]];then
        echo "Invalid parameter, please check." >> ${LOG_FILE}
        exit 1
    fi
    ipstr=$1
    hostnamestr=$2
    OLD_IFS="$IFS"
    IFS=","
    iplist=($ipstr)
    hostnamelist=($hostnamestr)
    IFS="$OLD_IFS"
    len="${#iplist[@]}"
    for ((i=0; i<len; i++))
        do
            check_ipv4 "${iplist[i]}"
            ipv4_flag=$?
            check_ipv6 "${iplist[i]}"
            ipv6_flag=$?
            check_hostname "${hostnamelist[i]}"
            hostname_flag=$?
            if [[ (${ipv4_flag} == 1 && ${ipv6_flag} == 1) || ${hostname_flag} == 1 ]];then
                echo "Invalid parameter." >> ${LOG_FILE}
                return 1
            else
                echo "${iplist[i]} ${hostnamelist[i]}" >> /etc/hosts
            fi
        done
    return 0
}

#*************************************************************
# Name:        check_ipv4
# Description: check whether ip is valid
# Input:  ip
# Return: 0 -- success; not 0 -- failure
# Date:    2019-08-08
#*************************************************************
check_ipv4()
{
    ipaddr=$1
    if [[ x$ipaddr == x ]];then
        echo "IPv4 $1 is illegal!" >> ${LOG_FILE}
        return 1
    fi
     valid_check=$( echo  $ipaddr| awk  -F.  '$1<=255&&$2<=255&&$3<=255&&$4<=255{print "yes"}' )
     if  echo  $ipaddr| grep  -E  "^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$" > /dev/null ;  then
         if  [ ${valid_check:-no} ==  "yes"  ];  then
             return 0
         else
             echo  "IPv4 $ipaddr not available!" >> ${LOG_FILE}
             return 1
         fi
     else
         echo  "IP $ipaddr format error!" >> ${LOG_FILE}
         return 1
     fi
}

#*************************************************************
# Name:        check_ipv6
# Description: check whether ip is valid
# Input:  ip
# Return: 0 -- success; not 0 -- failure
# Date:    2019-08-08
#*************************************************************
check_ipv6()
{
  ipaddr=$1
  matchResult=`echo "$ipaddr" | grep -E "^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$"`

      if [[ "$matchResult" != "$ipaddr" ]];then
          echo  "IPv6 $ipaddr not available!" >> ${LOG_FILE}
          return 1
      fi
  return 0
}

check_hostname()
{
  hostname=$1
  if echo $hostname | grep -E "^[a-zA-Z][a-zA-Z0-9-]{0,61}[a-zA-Z0-9]$" > /dev/null
  then
      if echo $hostname | grep -E "^[Ll][Oo][Cc][Aa][Ll][Hh][Oo][Ss][Tt]$" > /dev/null
      then
          echo "hostname $hostname not available" >> ${LOG_FILE}
          return 1
      else
          return 0
      fi
  else
      echo "hostname $hostname not available" >> ${LOG_FILE}
      return 1
  fi
}

main $*
exit $?

