'''
use this to upgrade web privilege
'''
# !/usr/bin/python
# -*- coding: utf-8 -*-
import os.path
import sys
import json
import time

sys.path.append(str(sys.argv[1]))
from getDBConnection import get_zenith_session


class WebPrivilegeMigrate:
    def __init__(self, template, product_name="NCE"):
        self.undefault_roles = []
        self.old_to_new_oper = template

        self.userdb_sess = get_zenith_session('userdb', 'userdb', product_name)
        if self.userdb_sess is None:
            print("[WebPrivilegeMigrate]invbasedb_sess is None")
            return
        self.userdb_sess.autocommit(True)
        self.userdb_cursor = self.userdb_sess.cursor()

        self.privilegedb_sess = get_zenith_session('privilegedb', 'privilegedb', product_name)
        if self.privilegedb_sess is None:
            print("[WebPrivilegeMigrate]get topodb_sess session fail")
            return
        self.privilegedb_sess.autocommit(True)
        self.privilegedb_cursor = self.privilegedb_sess.cursor()
        print('[WebPrivilegeMigrate]get topodb_sess success!')

        self.inventorydb_sess = get_zenith_session('InventoryDB', 'InventoryDB', product_name)
        if self.inventorydb_sess is None:
            print("[WebPrivilegeMigrate]get inventorydb_sess session fail")
            return
        self.inventorydb_sess.autocommit(True)
        self.inventorydb_cursor = self.inventorydb_sess.cursor()

        self.idmappingdb_sess = get_zenith_session('idmappingdb', 'idmappingdb')
        if self.idmappingdb_sess is None:
            print("[WebPrivilegeMigrate]get idmappingdb_sess session fail")
            return
        self.idmappingdb_sess.autocommit(True)
        self.idmappingdb_cursor = self.idmappingdb_sess.cursor()

    def get_undefault_role(self):
        print("[get_undefault_role] start")
        self.userdb_cursor.execute('SELECT ID FROM USERDB.ROLE WHERE ISDEFAULT=0')
        undefault_roles = self.userdb_cursor.fetchall()
        if undefault_roles:
            self.undefault_roles = list(undefault_roles)

        print("[get_undefault_role] the  undefault roles size: %d" % (len(self.undefault_roles)))

    def get_all_opid_by_role(self, curr_role):
        select_stmt = 'SELECT OPID FROM PRIVILEGEDB.ROLE_OP_RELATION WHERE ROLEID=%d' \
                      % (int(curr_role))
        raw_operid_list = []
        print("select_stmt sql:%s" % select_stmt)
        self.privilegedb_cursor.execute(select_stmt)
        raw_operids = self.privilegedb_cursor.fetchall()
        for raw_operid in raw_operids:
            raw_operid_list.append(list(raw_operid)[0])

        print("the role's oper is:%s" % raw_operid_list)
        return raw_operid_list

    def insert_new_operid(self, curr_role, new_operid):
        # 重复插入会失败，抛异常即可
        insert_stmt = "INSERT INTO PRIVILEGEDB.ROLE_OP_RELATION (ROLEID, OPID, ORGID) VALUES" \
                      "(%d, '%s', '%s')" % (int(curr_role), new_operid, "default-organization-id")
        print("insert_stmt: %s" % insert_stmt)
        try:
            self.privilegedb_cursor.execute(insert_stmt)

        except Exception as err:
            print("[insert_new_operid] err is: %s" % err)
            print("[insert_new_operid]may be hava dumplicate opid, err is: %s" % insert_stmt)

    def update_new_oper_impl(self, curr_role):
        print("[update_new_oper_impl] start")
        raw_operids = self.get_all_opid_by_role(curr_role)
        for raw_operid in raw_operids:
            new_operid = self.old_to_new_oper.get(raw_operid)
            if new_operid:
                for one_operid in new_operid:
                    self.insert_new_operid(curr_role, one_operid)
        print("[update_new_oper_impl] end")

    def batch_update_new_oper(self):
        print("[batch_update_new_oper] start")
        for undefault_role in self.undefault_roles:
            curr_role = list(undefault_role)[0]  # undefault_role: (12,)
            self.update_new_oper_impl(curr_role)

        print("[batch_update_new_oper] end")

    def update_operset_op(self):
        print("[update_operset_op] start")
        select_stmt = "SELECT OPSETID,OPID FROM PRIVILEGEDB.T_OPSET_OP_RELATION"
        self.privilegedb_cursor.execute(select_stmt)
        opids_raw = self.privilegedb_cursor.fetchall()

        info_data = self.old_to_new_oper
        for sql_line in opids_raw:
            opsetid = sql_line[0]
            opid = sql_line[-1]

            if opid in info_data.keys():
                insert_li = info_data[opid]

                for insert_info in insert_li:
                    insert_sql = "INSERT into PRIVILEGEDB.T_OPSET_OP_RELATION(OPSETID,OPID) " \
                                 "values(%s,'%s')" % (opsetid, insert_info)
                    try:
                        self.privilegedb_cursor.execute(insert_sql)
                    except Exception as err:
                        print("[update_operset_op] err is: %s" % err)
                        print("[update_operset_op]may be hava "
                              "dumplicate opid, err is: %s" % insert_sql)

        print(time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(time.time())) + "[update_operset_op] end")

    def delete_redundant_op_with_operset(self):
        print("[delete_redundant_op_with_operset] start")
        # 取权限11535570和11535411的差集
        select_stmt = "SELECT OPSETID FROM T_OPSET_OP_RELATION WHERE OPID = 'EMS.APP.201_100.11535570' " \
                      "EXCEPT SELECT OPSETID FROM T_OPSET_OP_RELATION WHERE OPID = 'EMS.APP.201_100.11535411'"
        self.privilegedb_cursor.execute(select_stmt)
        opsetids_raw = self.privilegedb_cursor.fetchall()
        opsetids = []
        for sql_line in opsetids_raw:
            opsetids.append(sql_line[0])
        if len(opsetids) == 0:
            print("[delete_redundant_op_with_operset] redundant operation resourcepool_ipv4pool_delete "
                  "with opersets is empty")
            return
        print("[delete_redundant_op_with_operset] redundant operation resourcepool_ipv4pool_delete with "
              "opersets %s will delete" % opsetids)
        delete_sql = "DELETE FROM T_OPSET_OP_RELATION WHERE OPID = 'resourcepool_ipv4pool_delete' " \
                     "AND OPSETID IN (%s)" % ",".join(str(opset) for opset in opsetids)
        try:
            self.privilegedb_cursor.execute(delete_sql)
        except Exception as err:
            print("[delete_redundant_op_with_operset] err is: %s, sql is %s" % (err, delete_sql))
        print("[delete_redundant_op_with_operset] end")

    def delete_redundant_op_with_role(self):
        print("[delete_redundant_op_with_role] start")
        # 取权限11535570和11535411的差集
        select_stmt = "SELECT ROLEID FROM ROLE_OP_RELATION WHERE OPID = 'EMS.APP.201_100.11535570' " \
                      "EXCEPT SELECT ROLEID FROM ROLE_OP_RELATION WHERE OPID = 'EMS.APP.201_100.11535411'"
        self.privilegedb_cursor.execute(select_stmt)
        roleids = []
        roleids_raw = self.privilegedb_cursor.fetchall()
        for sql_line in roleids_raw:
            roleids.append(sql_line[0])
        if len(roleids) == 0:
            print("[delete_redundant_op_with_role] redundant operation resourcepool_ipv4pool_delete "
                  "with roles is empty")
            return
        # 和非默认的角色取交集
        undefault_roles = []
        for undefault_role in self.undefault_roles:
            undefault_roles.append(undefault_role[0])
        roleids = set(roleids).intersection(set(undefault_roles))
        print("[delete_redundant_op_with_role] redundant operation resourcepool_ipv4pool_delete with "
              "roles %s will delete" % roleids)
        delete_sql = "DELETE FROM ROLE_OP_RELATION WHERE OPID = 'resourcepool_ipv4pool_delete' " \
                     "AND ROLEID IN (%s)" % ",".join(str(role) for role in roleids)
        try:
            self.privilegedb_cursor.execute(delete_sql)
        except Exception as err:
            print("[delete_redundant_op_with_role] err is: %s, sql is %s" % (err, delete_sql))
        print("[delete_redundant_op_with_role] end")

    def close_session(self):
        self.userdb_cursor.close()
        self.userdb_sess.close()
        self.privilegedb_cursor.close()
        self.privilegedb_sess.close()
        self.inventorydb_cursor.close()
        self.inventorydb_sess.close()
        self.idmappingdb_cursor.close()
        self.idmappingdb_sess.close()

    def update_oper_handle(self):
        print(time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(time.time())) + "[update_oper_handle] start to hanle >>>>>>>>>>>>>>>>>>>>>>>")
        self. get_undefault_role()
        print(time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(time.time())) + "[update_oper_handle] get default role")
        self.batch_update_new_oper()
        print(time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(time.time())) + "[update_oper_handle] batch update rule oper ")
        self.update_operset_op()
        print(time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(time.time())) + "[update_oper_handle] delete redundant oper with operset")
        self.delete_redundant_op_with_operset()
        print(time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(time.time())) + "[update_oper_handle] delete redundant oper with role")
        self.delete_redundant_op_with_role()
        self.close_session()
        print(time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(time.time()))+ "[update_oper_handle]end to hanle <<<<<<<<<<<<<<<<<<<<<<<")

def read_data_from_json(tamplate_path):
    raw_to_new_operid = {}
    real_path = os.path.realpath(tamplate_path)
    if not real_path.startswith("/opt/upgrade/easysuite_upgrade"):
        return raw_to_new_operid
    with open(real_path, 'r') as my_file:
        config_json = json.load(my_file)
    if isinstance(config_json, dict):
        for cfg in config_json:
            raw_to_new_operid[cfg['raw_oper']] = cfg['new_oper']
    elif isinstance(config_json, list):
        for cfg in config_json:
            raw_to_new_operid[cfg['raw_oper']] = cfg['new_oper']

    print("[read_data_from_json] result:%s" % raw_to_new_operid)
    return raw_to_new_operid

if __name__ == '__main__':
    if len(sys.argv) != 4:
        print('usage: python to upgrade phyinv web privilege, args length error ')
        sys.exit(-1)

    print("start to upgrade privilege-------------------------")
    TEMPLATE_PATH = sys.argv[2]
    product_name = sys.argv[3]
    print("upgrade privilege product_name is %s-------------------------" % product_name)
    CONVERT_TEMPLATE = read_data_from_json(TEMPLATE_PATH)
    UPDATE_HELPER = WebPrivilegeMigrate(CONVERT_TEMPLATE, product_name)
    UPDATE_HELPER.update_oper_handle()
    print(time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(time.time())) + "----upgrade privilege end!--------")