#!/bin/bash
SCRIPT_NAME=`basename $0`
LOG_FILE="/opt/oss/log/manager/SMPAgentService/${SCRIPT_NAME}.log"
DIR=/opt/oss/share/manager
FLAG_FILE=$DIR/easysuit_dfs_onupgrading.flag
CUR_USR=$(whoami)
# 用于日志展示步骤类型
STEP_NAME="pre_rollback"

# 日志记录
function log()
{
    local msg=$1
    echo "[$(date +'%Y-%m-%d %H:%M:%S')] $msg" >> $LOG_FILE
}
# 数据库碎片清理功能关闭（为了兼容新老版本）
function awareDbFragmentSwitchPy()
{
      . /opt/oss/manager/bin/engr_profile.sh
python <<EOF
import json
import os
import sys
NODELISTS_FILE_PATH = "/opt/oss/manager/etc/sysconf/nodelists.json"
node_list=""
IR_PORT=32038
QUERY_URL="/rest/smpmanagerservice/v1/dbfragmentclear/dbfragmentcleargettimer"
UPDATE_URL="/rest/smpmanagerservice/v1/dbfragmentclear/dbfragmentcleartimer"
from util import httpclient
try:
    with open(NODELISTS_FILE_PATH, "r") as file_obj:
        data = json.load(file_obj)
        for node in data.get("nodeList").values():
            if "MGR" not in node.get("role"):
                continue
            for ip in node.get("IPAddresses"):
                if "maintenance" in ip.get("usage"):
                    ip=ip.get("IP")
                    client=httpclient.CommonHttpClient(ip,IR_PORT,True,False)
                    queryRes=client.get(QUERY_URL)
                    print('dbfragment queryres:' + str(queryRes))
                    queryCode=queryRes[0]
                    param=None
                    if queryCode == 200:
                        param=json.loads(queryRes[1])
                        print('orign dbfragment config:' + str(param))
                    else:
                        continue

                    if param and param['clearSwitch']:
                        param['clearSwitch']='false'
                        updateRes=client.post(UPDATE_URL,param)
                        updateCode=updateRes[0]
                        print('send dbfragment close to :' + ip + ' param:' + str(param) + ' updateCode:' + str(updateCode))
                        if updateCode == 200:
                            exit()
                    else:
                        print('orign switch is:' + str(param['clearSwitch']) + ' no need close')
                        exit()
except Exception as ex:
    print('close dbfragment occur Exception:', ex)
EOF
}

# 通用告知微服务
function awareReqestPy()
{
      . /opt/oss/manager/bin/engr_profile.sh
python <<EOF
import json
import os
import sys
NODELISTS_FILE_PATH = "/opt/oss/manager/etc/sysconf/nodelists.json"
node_list=""
STEP_CODE="pre_rollback";
IR_PORT=32038
ARWARE_URL="/rest/smpmanagerservice/v1/monitorservices/upgradeaware"
from util import httpclient
try:
    with open(NODELISTS_FILE_PATH, "r") as file_obj:
        data = json.load(file_obj)
        for node in data.get("nodeList").values():
            if "MGR" not in node.get("role"):
                continue
            for ip in node.get("IPAddresses"):
                if "maintenance" in ip.get("usage"):
                    ip=ip.get("IP")
                    client=httpclient.CommonHttpClient(ip,IR_PORT,True,False)
                    param={'code':STEP_CODE}
                    res=client.post(ARWARE_URL,param)
                    resCode=res[0]
                    print('aware to:' + ip + ' param:' + str(param) + ' resCode:' + str(resCode))
                    if resCode == 200:
                        exit()
except Exception as ex:
    print('aware dfs occur Exception:', ex)
EOF
}

# 移除标志
function doAction()
{
    IFS=$'\n'
    log "begin ${STEP_NAME} dbfragment action"
    # 关闭数据库碎片清理
    for line in $(awareDbFragmentSwitchPy)
    do
       log $line
    done
    log "end ${STEP_NAME} dbfragment action"

    log "begin ${STEP_NAME} aware action"
    # 指定换行符，将python中输出的内容记录到日志中
    for line in $(awareReqestPy)
    do
       log $line
    done
    log "end ${STEP_NAME} aware action"
}
# 此动作失败也不应该影响升级，故异步执行
doAction &
exit 0