#!/bin/bash
SCRIPT_NAME=`basename $0`
cur_path=$(cd $(dirname $0);pwd)
LOG_FILE="/opt/oss/log/manager/SMPAgentService/${SCRIPT_NAME}.log"
DIR=/opt/oss/share/manager
FLAG_FILE=$DIR/easysuit_dfs_onupgrading.flag
CUR_USR=$(whoami)
# 用于日志展示步骤类型
STEP_NAME="delay healthcheck schedule"

# 日志记录
function log()
{
    local msg=$1
    echo "[$(date +'%Y-%m-%d %H:%M:%S')] $msg" >> $LOG_FILE
}

# 移除标志
function doAction()
{
    log "begin delayHCSchedule env seting."
    . /opt/oss/manager/bin/engr_profile.sh
    while read line; do export $line; done</opt/oss/manager/apps/SMPAgentService/envs/env.properties
    while read line; do export $line; done</opt/oss/manager/apps/SMPAgentService/envs/SMPAgentService.properties
    while read line; do export $line; done</opt/oss/manager/apps/SMPAgentService/envs/smpagentservice.properties
    while read line; do export $line; done</opt/oss/manager/apps/SMPAgentService/envs/upgrade.properties
    export PYTHONPATH=/opt/oss/manager/apps/SMPAgentService/pyscript
    export SMPMANAGERSERVICE_JSON=$(find /opt/oss/manager/apps/SMPManagerService/etc/sysconf/ -type f -name "SMPManagerService*.json");
    export LD_LIBRARY_PATH="/opt/oss/manager/apps/SMPAgentService/dbdriver_zenith/pyscript/zenith"
    log "begin call delayHcSchedule.pyc mission."
    if [ -f "${cur_path}/delayHcSchedule.pyc" ];then
        python ${cur_path}/delayHcSchedule.pyc
    elif [ -f "${cur_path}/delayHcSchedule.py" ];then
        python ${cur_path}/delayHcSchedule.py
    else
        log "there is no delayHcSchedule.pyc or delayHcSchedule.py in dir."
    fi
    log "finish delayHCSchedule"
}
# 此动作失败也不应该影响升级，故异步执行
doAction &
exit 0