#!/bin/bash

##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

function disable_schedule_task()
{
    pyscript="${SCRIPT_PATH}/../pyscripts/operate_schedule.py"
    if [ ! -f "${pyscript}" ]
    then
        pyscript="${SCRIPT_PATH}/../pyscripts/operate_schedule.pyc"
    fi
    python ${pyscript} "disable" "$@"
    if [ $? -ne 0 ]
    then
        return 2
    fi
}

function check_omp_task()
{
    . /opt/oss/manager/bin/engr_profile.sh
    check_result=$(python <<END
import json
from util import httpclient
query_omp_tasks_url = f'/rest/plat/omp/v1/main/common/taskmgr/pagingtasks?' \
                       'jobType=ui&page-length=20&page-size=1'
for i in range(0, 3):
    status, response = httpclient.IRHttpClient().get(query_omp_tasks_url)
    if i == 2 or status == 200:
        break
if status != 200:
    print("Error")
    exit()
omp_tasks = json.loads(response).get("taskList", [])
for task in omp_tasks:
    currentState = task.get('currentState')
    isEnabled = task.get('isEnabled')
    isScheduleJob = task.get('isScheduleJob')
    if currentState in ['RUNNING','TERMINATING']:
        print("False")
        exit()
    if currentState == "WAITING" and ((isScheduleJob == "yes" and isEnabled == "yes") or isScheduleJob == "no"):
        print("False")
        exit()
END
)
    if [ "${check_result}" == "Error" ]
    then
        return 3
    elif [ "${check_result}" == "False" ]
    then
        return 1
    else
        disable_schedule_task "$@"
        return $?
    fi
    return 0
}

function main()
{
    check_omp_task "$@"
    return $?
}

main "$@"
exit $?
