#!/bin/bash
##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"
OSS_USER=$(id -nu 3001)

##################################################
# 校验执行用户
# 脚本要求使用ossadm用户执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    if [ "${user}" != "${OSS_USER}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

##################################################
# 日志记录进/tmp/${SELF_FILE}.log
##################################################
function LOG()
{
    BASH_PID=$$
    if [ "$1" = "ERROR" -o "$1" = "error" ]
    then
        Level="ERROR"
    elif [ "$1" = "WARN" -o "$1" = "warn" ]
    then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${BASH_PID}] | ${Level} $2" | tee -a ${LOG_FILE}
}

# 入参校验
function check_param()
{
    local check_tmp=$1
    [ -z "${check_tmp}" ] && return 1
    echo "${check_tmp}" | fgrep -q "../"
    if [ $? -eq 0 ]
    then
        LOG "ERROR" "The input param \"${check_tmp}\" is invalid."
        return 1
    fi
    if [ ! -d "${check_tmp}" ]
    then
        LOG "ERROR" "The input param \"${check_tmp}\" is invalid."
        return 1
    fi
}

# 获取输入参数
function init_params()
{
    local num=$#
    if [ $((${num}%2)) -eq 1 ]
    then
        num=$((${num}/2+1))
    else
        num=$((${num}/2))
    fi
    local count=1
    for((i=1;i<=${num};i++))
    do
        [[ ${1#-} == "input" ]] && { INPUTPATH=$2;shift 2;check_param "${INPUTPATH}" || return 1; continue; }
    done
}

function check_input()
{
    init_params "$@"
    if [ $? -ne 0 ]
    then
        echo "Example: bash ${SELF_FILE} -input /opt/upgrade/easysuite_upgrade/workpath/V100R019C00SPC602-V100R020C00/workpath-NCE/"
        return 1
    fi
}

# 查询产品高斯进程是否启动,未启动需要启动进程
function start_product_gauss()
{
    PRODUCTNAME=$(cat ${INPUTPATH}/plandata.json 2>/dev/null | python -c "import json; import sys; obj=json.load(sys.stdin); print(obj['productname'])" 2>/dev/null)
    if [ -z "${PRODUCTNAME}" ]
    then
        LOG "ERROR" "Productname is null."
        return 1
    fi
    SSHTOOL="${OSS_ROOT}/tools/common/sshmgr/sshmgr.sh"
    LOG "INFO" "Start to start ${PRODUCTNAME} GaussDB."
    GAUSS_DBIPS=($(${OSS_ROOT}/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -tenant ${PRODUCTNAME} | grep gauss | awk '{print $6}' | sort -u))
    if [ -z "${GAUSS_DBIPS}" ]
    then
        LOG "WARN" "Product ${PRODUCTNAME} does not use the GaussDB."
    else
        ${OSS_ROOT}/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -tenant ${PRODUCTNAME} | grep gauss | awk '{print $3 "\t" $6}' | while read line
        do
            local instname=$(echo ${line} | awk '{print $1}')
            local instip=$(echo ${line} | awk '{print $2}')
            bash ${SSHTOOL} -exectype cmd -ip ${instip} -cmd "ps -ef | grep /opt/gauss | grep -v grep | grep -w ${instname}" -u ${OSS_USER} -timeout 3600 -encrypt N >>"${LOG_FILE}" 2>&1
            if [ $? -ne 0 ]
            then
                bash ${SSHTOOL} -exectype cmd -ip ${instip} -cmd "sudo -u dbuser bash -c \"cd ~; source appgsdb.bashrc&&/opt/gauss/app/bin/gs_ctl start -M primary -D /opt/gauss/data/${instname}\"" -u ${OSS_USER} -timeout 3600 -encrypt N >>"${LOG_FILE}" 2>&1
                if [ $? -ne 0 ]
                then
                    LOG "ERROR" "Failed to start ${instname} on ${instip}."
                    return 1
                fi
            fi
        done
        LOG "INFO" "Finished to start ${PRODUCTNAME} GaussDB."
    fi
}

function main()
{
    check_user || return 1
    # 创建日志目录
    [ ! -d "${LOG_PATH}" ] && mkdir -p ${LOG_PATH}
    . /opt/oss/manager/bin/engr_profile.sh
    check_input "$@" || return 1
    start_product_gauss || return 1
}

main "$@"
exit $?
