# -*- coding: utf-8 -*-

import sys

from uniep.utils.db import dbhelper

from commonlog import Logger

logger = Logger().getinstance(sys.argv[0])


class ModifyPatchStatusTool:

    @staticmethod
    def get_conn():
        conn = dbhelper.get_connection('UniEPService', 'ospatchdb')
        if not conn:
            conn = dbhelper.get_connection('UniEPLiteService', 'ospatchdb')
        return conn

    def update_status(self, package_name, action="uninstall"):
        """
        :param package_name:补丁包名
        :param action:install/uninstall,2表示以安装，1表示未安装
        :return:
        """
        conn = self.get_conn()
        if not conn:
            logger.info("Failed to obtain the data connection.")
            return 1
        if action == "install":
            conn.post("UPDATE TAL_PATCH_INFO SET PATCHINSTALLSTATUS=%s WHERE PATCHPACKAGENAME=%s",
                      [2, package_name])
        else:
            conn.post("UPDATE TAL_PATCH_INFO SET PATCHINSTALLSTATUS=%s WHERE PATCHPACKAGENAME=%s",
                      [1, package_name])
        return 0


def main(argv):
    """
    主程序入口，根据包名刷新补丁状态
    """
    action = argv[1]
    package_name = argv[2]
    tool = ModifyPatchStatusTool()
    return tool.update_status(package_name, action)


if __name__ == '__main__':
    sys.exit(main(sys.argv))
