# coding=utf-8
# 1. 不支持sp补丁
import subprocess
import uuid
import os
import time

from uniep.utils.os.path import cloudsoppath
from uniep.utils.log import systraceutils
from uniep.utils.io import file as file_util
from uniep.utils.node import nodelist
from uniep.utils.decorators import decorator
from uniep.utils.threads import multiwork
from uniep.utils.net.httpclient import httpclient
from uniep.utils.json import easyjson

LOGGER = systraceutils.get_default_logger()
PACKAGE_INFO_CACHE = {}
PACKAGE_CACHE = {}


def ipmc_fuzzy_calculate_pkgs(input_file):
    LOGGER.info('the input file %s', input_file)
    input_json = easyjson.load_json_file(input_file)
    product_name = input_json['productname']
    current_features = [feature['name'] for feature in input_json['featuregrouplist'][0]['features']]
    current_feature_group = input_json['featuregrouplist'][0]['name']
    components = [f'{item.get("name")}-{item.get("version")}' for item in input_json['packages']]

    component_names = ','.join([component.split('-')[0] for component in components])
    component_versions = ','.join([component.split('-')[1] for component in components])
    url = f'/rest/plat/repo/v2/main/productpkg/templates?software-name={component_names}&software-version={component_versions}&page-size=5'
    resp = _send_request_with_short_timeout(url)
    component_datas = easyjson.load_json_from_string(resp).get('entity').get('data')
    services = []
    for component_data in component_datas:
        template = easyjson.load_json_from_string(component_data.get('softwareDefine'))
        if not template or 'featureGroup' not in template:
            LOGGER.info('the package not define feature group: %s', component_data.get('packageName'))
            continue
        for feature in template.get('featureGroup').get(current_feature_group):
            if feature in current_features:
                for service in template.get('featureGroup').get(current_feature_group).get(feature):
                    services.append((service.get('serviceName'), service.get('deployTemplate')))

    # 找到服务模板，找到微服务资源列表
    resp = _send_request_with_short_timeout(f'/rest/plat/repo/v1/main/service-pkgs?prod-pkgs={",".join(components)}')
    all_service_packages = {item.get('name'): item.get('version') for item in easyjson.load_json_from_string(resp).get('entity')}
    # 20一批次查询服务模板信息，防止body超过规定大小
    all_resources = []
    for i in range(len(services)//20+1):
        services_partition = services[i*20: (i+1)*20]
        packages = []
        for service in services_partition:
            LOGGER.info('query service template for %s', service[0])
            name = service[0]
            template = service[1].replace('.json', '')
            packages.append({'package-name': f'{name}-{all_service_packages.get(name)}', 'tmpl-name': template})
        resp = _send_post_request_with_short_timeout('/rest/plat/repo/v2/main/serivce/stacks-tmpls', {'packages': packages})
        for service_template in easyjson.load_json_from_string(resp).get('entity'):
            all_resources.append(easyjson.load_json_from_string(service_template.get('content')).get('resources'))

    # 所有微服务包版本和类型信息
    component_packages = []
    resp = _send_request_with_short_timeout('/rest/plat/repo/v1/main/productpkg/components')
    for pkg in easyjson.load_json_from_string(resp).get('entity'):
        name = pkg.get('softwareName')
        version = pkg.get('softwareVersion')
        if f'{name}-{version}' in components:
            component_packages.append(pkg.get('packageName'))
    micro_pkgs = {}
    page_num = 0
    total_num = 50
    while total_num > page_num * 50:
        page_num += 1
        resp = _send_request_with_short_timeout(
            f'/rest/plat/repo/v2/main/microservice-pkgs?prod-pkgs={",".join(component_packages)}&page-size=50&page-num={page_num}')
        resp_json = easyjson.load_json_from_string(resp)
        total_num = resp_json.get('entity').get('totalNum')
        for micro_pkg in resp_json.get('entity').get('data'):
            micro_pkgs[micro_pkg['name']] = (micro_pkg.get('version'), micro_pkg.get('type'))

    # 所有节点标签
    node_tags = {}
    client = _get_direct_http_client()
    status, resp = client.get('/rest/plat/sysmgr/v1/main/resmgr/list/nodelist4UI')
    for node in easyjson.load_json_from_string(resp).get('entity').get('data'):
        node_id = node.get('id')
        for item in node.get('tags'):
            if item.get('opKey') == 'ServerGroup':
                for tag in item.get('opValue').split(','):
                    if tag not in node_tags:
                        node_tags[tag] = []
                    node_tags[tag].append(node_id)
    # TODO: 在人机、机机场景下往后升级
    user_maps = {
        'ossrunuser': 'ossuser',
        'admrunuser': 'ossadm',
        'secuser': 'ossuser'
    }

    # 计算微服务列表
    results = []
    for resources in all_resources:
        for name in resources:
            if resources.get(name).get('type') != 'Stage':
                continue
            run_user = resources.get(name.replace('/{{stageName}}', ''), {}).get('properties', {}).get('runAs', 'ossuser')
            if run_user != 'ossuser':
                LOGGER.info('the resource run as user is not oss user: %s, %s', name, run_user)
            if run_user == 'secuser':
                LOGGER.info('the resource run as user is secuser: %s, %s, ignore', name, run_user)
                continue
            run_user = user_maps.get(run_user, run_user)
            server_group = list(resources.get(name).get('properties').get('serverGroup').keys())[0]
            server_group = server_group.replace('{{regionAlias}}', product_name)
            nodes = node_tags.get(server_group)
            if not nodes:
                LOGGER.info('the service %s node tags missing: %s', name, server_group)
                continue
            packages = []
            app_name = ''
            for package_name in resources.get(name).get('properties').get('packages'):
                package_name = package_name.replace('~', '')
                if package_name not in micro_pkgs:
                    LOGGER.info('the package missing: %s', package_name)
                    continue
                version, pkg_type = micro_pkgs.get(package_name)
                if pkg_type == 'app':
                    app_name = package_name
                packages.append({'name': package_name, 'version': version, 'type': pkg_type})
            if app_name:
                results.append({'name': app_name, 'packages': packages, 'nodes': nodes, 'user': run_user})
            else:
                LOGGER.info('the micro service missing: %s', app_name)
    dump_changes({'entity': {'contents': results}}, product_name)


def ipmc_calculate_pkgs(input):
    input_json = easyjson.load_json_file(input)
    product_name = input_json['productname']
    data = {
        "scenario": input_json['featuregrouplist'][0]['name'],
        "featureList": [feature['name'] for feature in input_json['featuregrouplist'][0]['features']],
        "productName": product_name,
        "packages": input_json['packages'],
        "configs": {
            "properties": [
            ],
            "sysProperties": [
                {
                    "name": "deployType",
                    "value": "Upgrade",
                    "type": "string"
                }
            ]
        }
    }
    url = f'/rest/plat/deployapp/v2/deployments/pre/{product_name}/product-deploy-changes'
    client = _get_direct_http_client()
    status, resp = client.post(url, data)
    LOGGER.info('create the changes result: %s', resp)
    change_id = easyjson.load_json_from_string(resp).get('entity').get('changeId')
    status, resp = client.get(change_id)
    dump_changes(resp, product_name)


def _get_direct_http_client():
    # 解决SIA兼容性问题
    deploy_core_app_name = 'MCDeployService'
    if os.path.isdir(cloudsoppath.get_ipmc_path('apps', 'UniEPService', 'webapps', 'root#deploycoreservice')):
        deploy_core_app_name = 'UniEPService'
    if os.path.isdir(cloudsoppath.get_ipmc_path('apps', 'UniEPLiteService', 'webapps', 'root#deploycoreservice')):
        deploy_core_app_name = 'UniEPLiteService'

    app_version_file = ''
    for file_name in os.listdir(cloudsoppath.get_ipmc_path('apps', deploy_core_app_name, 'etc', 'sysconf')):
        if file_name.startswith(deploy_core_app_name) and file_name.endswith('.json'):
            app_version_file = cloudsoppath.get_ipmc_path('apps', deploy_core_app_name, 'etc', 'sysconf', file_name)
    app_version = easyjson.load_json_file(app_version_file)

    ip, port = '127.0.0.1', 0
    for process in app_version.get('processes', {}):
        if 'local' in app_version['processes'][process]:
            ip = app_version['processes'][process]['local']['ip']
            port = app_version['processes'][process]['local']['port']
    return httpclient.CommonHttpClient(ip, port, timeout=10, use_sia=False)


def dump_changes(changes, product_name):
    pkgs = {}
    node_id_ips = nodelist.NodeListMgr().get_node_maintaince_ips()
    for item in changes.get('entity').get('contents'):
        app_name = item.get('name')
        run_user = item.get('user')
        packages = _create_pkgs(item.get('packages', []))
        for node_id in item.get('nodes', []):
            ip = node_id_ips[str(node_id)]
            if ip not in pkgs:
                pkgs[ip] = {}
            pkgs[ip][f'{app_name}:{run_user}'] = packages
    for ip in pkgs:
        contents = f'[{product_name}]\n'
        for app_name_user in pkgs[ip]:
            app_name = app_name_user.split(':')[0]
            run_user = app_name_user.split(':')[1]
            contents += f'app:{app_name}:user:{run_user}\n'
            contents += '\n'.join(pkgs[ip][app_name_user])
            contents += '\n'
        file_util.safe_write_file(f'/tmp/pkgs_{ip}.txt', contents)


def _create_pkgs(packages):
    result = []
    for pkg in packages:
        name_version = f'{pkg["name"]}-{pkg["version"]}'
        if pkg["type"] != 'rtsp':
            name_version = name_version + '_unzipflag.txt'
        if pkg["type"] == 'app':
            result.insert(0, name_version)
        else:
            result.append(name_version)
    return result


@decorator.retry(10, 5)
def single_collect(ip):
    script_path = cloudsoppath.get_ipmc_path('agent/tools/pyscript/tools/pre_upgrade.py')
    engr_file = cloudsoppath.get_ipmc_path('bin', 'engr_profile.sh')
    status, output = subprocess.getstatusoutput(f'scp -o StrictHostKeyChecking=no {script_path} {ip}:{script_path}')
    LOGGER.info('cmd: %s, status: %s, output: %s',
                f'scp -o StrictHostKeyChecking=no {script_path} {ip}:{script_path}', status, output)
    status, output = subprocess.getstatusoutput(
        f'ssh -o StrictHostKeyChecking=no {ip} -n "source {engr_file}; ipmc_tool -cmd pre_upgrade -o creat_file_list_local"')
    LOGGER.info('cmd: %s, status: %s, output: %s',
                f'ssh -o StrictHostKeyChecking=no {ip} -n "source {engr_file}; ipmc_tool -cmd pre_upgrade -o creat_file_list_local"',
                status, output)
    pkg_list_file = f'/tmp/pkgs_{ip}.txt'
    status, output = subprocess.getstatusoutput(f'scp -o StrictHostKeyChecking=no {ip}:{pkg_list_file} {pkg_list_file}')
    LOGGER.info('cmd: %s, status: %s, output: %s',
                f'scp -o StrictHostKeyChecking=no {ip}:{pkg_list_file} {pkg_list_file}', status, output)


def ipmc_creat_file_list_local():
    local_ip = nodelist.get_local_node_ip()
    pkg_list_file = f'/tmp/pkgs_{local_ip}.txt'
    product_name = nodelist.get_local_node_tenant()
    LOGGER.info(f'collect {local_ip} packages {pkg_list_file}')
    if product_name != 'manager':
        collect = collect_template % {
            'ENGR_PROFILE': cloudsoppath.get_ipmc_path('bin', 'engr_profile.sh'),
            'PRODUCT_NAME': product_name,
            'OUTPUT_FILE': pkg_list_file
        }
        tmp_file = cloudsoppath.get_app_tmp_path(f'collect.sh')
        file_util.safe_write_file(tmp_file, collect, 0o750)
        res = subprocess.run(['bash', tmp_file], capture_output=True)
        LOGGER.info('execute %s, exitcode: %s, output: %s, err: %s', tmp_file, res.returncode, res.stdout,
                    res.stderr)
        if res.returncode != 0:
            raise Exception(f'execute {tmp_file} error')
    return 0


def ipmc_prepare_pkgs():
    LOGGER.info('prepare all nodes packages')
    multiwork.run_works(30, nodelist.get_all_nodes_ip(), single_prepare)
    return 0


def single_prepare(ip):
    script_path = cloudsoppath.get_ipmc_path('agent/tools/pyscript/tools/pre_upgrade.py')
    engr_file = cloudsoppath.get_ipmc_path('bin', 'engr_profile.sh')
    status, output = subprocess.getstatusoutput(f'scp -o StrictHostKeyChecking=no {script_path} {ip}:{script_path}')
    LOGGER.info('cmd: %s, status: %s, output: %s',
                f'scp -o StrictHostKeyChecking=no {script_path} {ip}:{script_path}', status, output)
    pkg_list_file = f'/tmp/pkgs_{ip}.txt'
    status, output = subprocess.getstatusoutput(f'scp -o StrictHostKeyChecking=no {pkg_list_file} {ip}:{pkg_list_file}')
    LOGGER.info('cmd: %s, status: %s, output: %s',
                f'scp -o StrictHostKeyChecking=no {pkg_list_file} {ip}:{pkg_list_file}', status, output)

    status, output = subprocess.getstatusoutput(
        f'ssh -o StrictHostKeyChecking=no {ip} -n "source {engr_file}; ipmc_tool -cmd pre_upgrade -o prepare_pkgs_local"')
    LOGGER.info('cmd: %s, status: %s, output: %s',
                f'ssh -o StrictHostKeyChecking=no {ip} -n "source {engr_file}; ipmc_tool -cmd pre_upgrade -o prepare_pkgs_local"',
                status, output)


def ipmc_prepare_pkgs_local():
    local_ip = nodelist.get_local_node_ip()
    pkg_list_file = f'/tmp/pkgs_{local_ip}.txt'
    product_name = nodelist.get_local_node_tenant()
    if product_name == 'manager':
        LOGGER.info('not handle manager')
        return 0
    files = get_file_list(pkg_list_file, product_name)
    download_pkgs(files, product_name)
    unzip_app_and_custom_files(files, product_name)
    return 0


def get_file_list(pkg_list_file, product_name):
    result = {'manager': [], product_name: []}
    tenant = ''
    last_app = {}
    if not os.path.isfile(pkg_list_file):
        return
    with open(pkg_list_file, 'r') as f:
        for line in f.readlines():
            line = line.strip()
            if not line:
                continue

            if '[manager]' == line:
                tenant = 'manager'
                continue
            if f'[{product_name}]' == line:
                tenant = product_name
                continue
            if line.startswith('app:'):
                if last_app:
                    result[tenant].append(last_app)
                last_app = {}
                last_app['name'] = line.split(':')[1]
                last_app['pkgs'] = []
                last_app['rtsps'] = []
                last_app['user'] = line.split(':')[3]
                continue

            if line.endswith('_unzipflag.txt'):
                last_app['pkgs'].append(line[:-len('_unzipflag.txt')])
            else:
                last_app['rtsps'].append(line)
        if last_app:
            result[tenant].append(last_app)
    return result


def download_pkgs(files, product_name):
    global PACKAGE_CACHE
    packages = []
    for item in files.get(product_name, []):
        packages.extend([(pkg, 'rtsp') for pkg in item['rtsps']])
        packages.extend([(pkg, 'other') for pkg in item['pkgs']])
    packages = list(set(packages))
    for pkg in packages:
        # 并发前设置好字典key，仅修改值是线程安全的
        PACKAGE_CACHE[pkg[0]] = ''
    create_package_info([pkg[0] for pkg in packages])
    failed_works = multiwork.run_works(30, packages, download_pkg_and_unzip_rtsp)
    if failed_works:
        LOGGER.info('download packages failed: %s', failed_works)


def create_package_info(pkg_ids):
    global PACKAGE_INFO_CACHE
    pkg_ids = list(set(pkg_ids))
    url = f'/rest/plat/repo/v1/main/microservice-pkgs?pkgs={",".join(pkg_ids)}'
    response = _send_request_with_short_timeout(url)
    LOGGER.info("Download by pkgid %s, response: %s", pkg_ids, response)
    pkg_infos = easyjson.load_json_from_string(response)
    for pkg_id in pkg_infos.get('entity'):
        PACKAGE_INFO_CACHE[pkg_id] = pkg_infos.get('entity').get(pkg_id)


def download_pkg_and_unzip_rtsp(pkg):
    global PACKAGE_CACHE
    pkg_id, pkg_type = pkg[0], pkg[1]
    local_path = download_by_pkgid(pkg_id)
    PACKAGE_CACHE[pkg_id] = local_path
    if local_path and pkg_type == 'rtsp':
        unzip_rtsp(pkg_id, local_path)


def unzip_app_and_custom_files(files, product_name):
    failed_works = multiwork.run_works(15, files.get(product_name, []), unzip_app_and_custom)
    if failed_works:
        LOGGER.info('unzip app and custom packages failed: %s', failed_works)


def unzip_app_and_custom(package_meta):
    global PACKAGE_CACHE
    app_name = package_meta['name']
    user = package_meta['user']
    app_version, app_pkg = get_app_version(app_name, package_meta['pkgs'])
    if 'sp' in app_version.lower():
        LOGGER.info('not support sp package')
        return
    print(f'download app pkg {app_pkg}')
    deploy_args = {
        'INSTALL_ROOT': cloudsoppath.get_install_path(),
        'APP_ROOT': cloudsoppath.get_install_path('envs', f"Product-{app_name}", app_version),
    }
    local_path = PACKAGE_CACHE[app_pkg]
    if not os.path.isfile(local_path):
        LOGGER.info('the file not found: %s', local_path)
        return
    deploy_args['LOCAL_PATH'] = local_path
    deploy_args['BASE_LOCAL_PKG_PATH'] = ''
    deploy_args['UNZIP_PATH'] = deploy_args['APP_ROOT']
    deploy_args['PKG_ID'] = app_pkg
    deploy_args['PKG_NAME'] = app_name
    deploy_args['PKG_TYPE'] = 'app'
    deploy_args['APP_RUN_USER'] = user
    deploy_args['UNZIP_FLAG_PATH'] = os.path.join(deploy_args['APP_ROOT'], f'{app_pkg}_unzipflag.txt')
    deploy_args['UUID'] = str(uuid.uuid1())
    deploy_args['MAIN_APP_NAME'] = app_name
    unzip_package(deploy_args)

    for pkg in package_meta['pkgs']:
        if pkg != app_pkg:
            LOGGER.info(f'unzip custom package {pkg}')
            local_path = PACKAGE_CACHE[pkg]
            deploy_args['PKG_TYPE'] = 'custom'
            deploy_args['LOCAL_PATH'] = local_path
            deploy_args['PKG_ID'] = pkg
            deploy_args['PKG_NAME'] = pkg.split('-')[0]
            deploy_args['UNZIP_FLAG_PATH'] = os.path.join(deploy_args['APP_ROOT'], f'{pkg}_unzipflag.txt')
            deploy_args['UUID'] = str(uuid.uuid1())
            unzip_package(deploy_args)


def get_app_version(app_name, pkgs):
    for pkg in pkgs:
        if pkg.startswith(app_name):
            return '-'.join(pkg.split('-')[1:]), pkg


def unzip_package(deploy_args):
    if os.path.isfile(deploy_args['UNZIP_FLAG_PATH']):
        return
    template = unzip_template % deploy_args
    tmp_file = cloudsoppath.get_app_tmp_path(f'unzip_{deploy_args["PKG_ID"]}_{os.path.basename(deploy_args["MAIN_APP_NAME"])}.sh')
    file_util.safe_write_file(tmp_file, template, 0o750)

    app_root = deploy_args['UNZIP_PATH']
    run_user = deploy_args['APP_RUN_USER']
    subprocess.getstatusoutput(
        f'mkdir -p {os.path.dirname(app_root)}; chmod 770 {os.path.dirname(app_root)}; sudo -u {run_user} mkdir {app_root}; chmod 750 {os.path.dirname(app_root)};')
    # bash 防止/tmp分区不可执行
    res = subprocess.run(['sudo', '-u', run_user, 'bash', tmp_file], capture_output=True)
    LOGGER.info('execute %s, exitcode: %s, output: %s, err: %s', tmp_file, res.returncode, res.stdout,
                res.stderr)
    if res.returncode != 0:
        raise Exception(f'execute {tmp_file} error')
    subprocess.getstatusoutput(f'rm -f {tmp_file}; sudo -u {run_user} chmod -R u+w,o-rwx {app_root}')


def unzip_rtsp(pkg_id, package_path):
    pkg_root = cloudsoppath.get_install_path('rtsp', pkg_id)
    unzip_flag = cloudsoppath.get_install_path('rtsp', pkg_id, f'{pkg_id}_unzipflag.txt')
    if os.path.isfile(unzip_flag):
        return
    res = subprocess.run(['unzip', '-qo', package_path, '-d', pkg_root], capture_output=True)
    LOGGER.info('execute rtsp unzip, exitcode: %s, output: %s, err: %s', res.returncode, res.stdout,
                res.stderr)
    cmds = [
        'find %s -type d -exec chmod 750 {} +' % pkg_root,
        'find %s -type f -exec chmod 640 {} +' % pkg_root,
        'find %s -type f -a \( -name "*.bat" -o -name "*.jar" -o -name "*.sh" -o -name "*.jar" -o -name "*.py" -o -name "*.pyc" -o -name "*.so" -o -name "*.bin" -o ! -name "*.*" \) -exec chmod 550 {} +' % pkg_root,
        'touch %s' % unzip_flag,
    ]
    for cmd in cmds:
        status, output = subprocess.getstatusoutput(cmd)
        LOGGER.info('execute cmd: %s, status: %s, output: %s', cmd, status, output)


def download_by_pkgid(pkgid):
    global PACKAGE_INFO_CACHE
    pkginfo = PACKAGE_INFO_CACHE[pkgid]
    relatepath = pkginfo.get("packages")[0].get('path')
    remotepath = '/repo/%s' % relatepath
    localpath = cloudsoppath.get_ipmc_path('var/installpackages/product/%s' % relatepath)
    if not os.path.isfile(localpath):
        _download_file(remotepath, localpath)
        _check_cms_sign(localpath)
    return localpath


def _send_request_with_short_timeout(url, retry_times=3, timeout=10):
    # 短超时时间，防网络抖动引起的链接挂住，导致执行慢
    for i in range(retry_times):
        for ip in _sorted_mgmt_ips():
            client = httpclient.CommonHttpClient(ip, 32038, timeout=timeout)
            status, response = client.get(url)
            if 200 <= status < 300:
                return response
        time.sleep(3)
    raise Exception('request error: %s' % url)


def _send_post_request_with_short_timeout(url, data, retry_times=3, timeout=10):
    # 短超时时间，防网络抖动引起的链接挂住，导致执行慢
    for i in range(retry_times):
        for ip in _sorted_mgmt_ips():
            client = httpclient.CommonHttpClient(ip, 32038, timeout=timeout)
            status, response = client.post(url, data)
            if 200 <= status < 300:
                return response
        time.sleep(3)
    raise Exception('request error: %s' % url)


@decorator.retry(3, 10)
def _download_file(remotepath, localpath):
    _download_pkg(localpath, remotepath)
    _download_pkg_from_remote('%s.cms' % localpath, '%s.cms' % remotepath)
    _download_pkg_from_remote('%s.crl' % localpath, '%s.crl' % remotepath)


def _download_pkg(local_path, remote_path):
    _download_pkg_from_remote(local_path, remote_path)
    if not os.path.isfile(local_path):
        LOGGER.error("Download file %s failed" % local_path)
        raise Exception('download file error')


def _download_pkg_from_remote(local_path, remote_path):
    irport = 32038
    for ip_addr in _sorted_mgmt_ips():
        try:
            url = 'https://%s:%s%s' % (is_ipv6_and_format(ip_addr), irport, remote_path)
            _download_pkg_by_url(url, local_path)
            break
        except BaseException:
            LOGGER.exception("Download file exception")
    if not os.path.isfile(local_path):
        LOGGER.error("Download file %s failed" % local_path)


def _sorted_mgmt_ips():
    # 负载均衡，备节点及偶数节点总是先尝试从0节点下载，其他奇数节点先尝试从1节点下载
    mgmt_ips = nodelist.get_mgmt_ips()
    local_node_id = int(nodelist.get_local_node_id())
    if local_node_id != 1 and local_node_id % 2 == 1:
        mgmt_ips.reverse()
    return mgmt_ips


def is_ipv6_and_format(ip_addr):
    return '[%s]' % ip_addr if is_ipv6(ip_addr) else ip_addr


def is_ipv6(ip_addr):
    return ":" in ip_addr


def _download_pkg_by_url(url, localpath):
    if not _already_download(localpath):
        httpclient.get_file(url, localpath)
    else:
        LOGGER.info('Package %s is already download' % localpath)


def _already_download(localpath):
    return os.path.isfile(localpath)


def _check_cms_sign(pkg_path):
    gpg_script = cloudsoppath.get_app_path('tools', 'shscript', 'gpgcheck.sh')
    # 兼容签名脚本位置变更
    if os.path.isfile(gpg_script):
        cmd = f"bash {gpg_script} {pkg_path}.cms {pkg_path} {pkg_path}.crl"
        status, out_put = subprocess.getstatusoutput(cmd)
        if status != 0:
            LOGGER.error("Failed to check pkg(%s) sign and output is %s" % (pkg_path, out_put))
            os.unlink(pkg_path)
            os.unlink(pkg_path+'.cms')
            os.unlink(pkg_path+'.crl')
            raise Exception('failed check sign')
        LOGGER.info("Success to check pkg(%s) sign and output is %s" % (pkg_path, out_put))

unzip_template = '''
#! /bin/bash
function init_global()
{
    INSTALL_ROOT=%(INSTALL_ROOT)s
    APP_ROOT=%(APP_ROOT)s
    LOCAL_PKG_PATH=%(LOCAL_PATH)s
    BASE_LOCAL_PKG_PATH=%(BASE_LOCAL_PKG_PATH)s
    DEST_UNZIP_PATH=%(UNZIP_PATH)s
    PKG_ID=%(PKG_ID)s
    PKG_NAME=%(PKG_NAME)s
    PKG_TYPE=%(PKG_TYPE)s
    APP_RUN_USER=%(APP_RUN_USER)s
    UNZIP_FLAG_PATH=%(UNZIP_FLAG_PATH)s
    LIB_DEPENDENCY_LIST_FILE=${DEST_UNZIP_PATH}/all.lib.dependencies
    RTSP_LIB_DEPENDENCY_LIST_FILE=${DEST_UNZIP_PATH}/all.rtsp.lib.dependencies
    UUID=%(UUID)s
}

function check_unziped()
{
    [[ -f ${UNZIP_FLAG_PATH} ]] && {
        echo "The package already unzipped to ${UNZIP_FLAG_PATH}"
        do_rtsp_link || return $?
        export_rtsp_libs || return $?
        exit 0
    }
}

function do_rtsp_link()
{
    [[ "$PKG_TYPE" = "rtsp" ]] && {
        echo "Create link file for $PKG_ID";
        sudo -u ${APP_RUN_USER} mkdir -p ${APP_ROOT}/rtsp
        sudo -u ${APP_RUN_USER} rm -f ${APP_ROOT}/rtsp/${PKG_NAME} 2>/dev/null;
        sudo -u ${APP_RUN_USER} ln -sf ${DEST_UNZIP_PATH} ${APP_ROOT}/rtsp/${PKG_NAME} || return 15;
    }
    return 0
}

function export_rtsp_libs()
{
    [[ ! -f ${DEST_UNZIP_PATH}/pub/export_libs.list ]] && return 0
    echo "The pub/export_libs.list defined, will export all libs."
    cat ${DEST_UNZIP_PATH}/pub/export_libs.list |awk -F',' '{print $2}' | while read filepath
    do
        libname=`basename $filepath`
        libhome=${INSTALL_ROOT}/lib${APP_RUN_USER}
        [[ -f ${libhome}/${libname} ]] && continue
        [[ ! -d "$libhome" ]] && mkdir -p "$libhome" -m 770
        chmod 770 "$libhome"
        chmod 440 ${DEST_UNZIP_PATH}/$filepath
        sudo -u ${APP_RUN_USER} cp ${DEST_UNZIP_PATH}/${filepath} ${libhome}/${UUID} || {
            echo "Copy the ${DEST_UNZIP_PATH}/${filepath} to ${libhome}/${UUID} failed.";
            return 107;
        }
        sudo -u ${APP_RUN_USER} mv ${libhome}/${UUID} ${libhome}/${libname} || {
            echo "Move the ${libhome}/${UUID} to ${libhome}/${libname} failed.";
            return 108;
        }
        sudo -u ${APP_RUN_USER} chmod 500 ${libhome}/${libname}
    done
    return 0
}

function decompress_pkg()
{
    local src_pkg=$1
    local dest_path=$2
    if [[ "${src_pkg}" =~ ^.*\.zip$ ]];then
        if [[ "$PKG_TYPE" == 'custom' ]];then
            /usr/bin/unzip -qo ${src_pkg} -d ${dest_path} $3
        else
            /usr/bin/unzip -qo ${src_pkg} -d ${dest_path}
        fi
    elif [[ "${src_pkg}" =~ ^.*\.7z$ ]];then
        ZIP7TOOL="/usr/local/osconfig/os/bin/7za"
        [[ ! -f "${ZIP7TOOL}" ]] && ZIP7TOOL=/usr/bin/7za
        if [[ "$PKG_TYPE" == 'custom' ]];then
            ${ZIP7TOOL} x ${src_pkg} -y -o${dest_path} $3
        else
            ${ZIP7TOOL} x ${src_pkg} -y -o${dest_path}
        fi
    fi
    return $?
}

function decompress_pkg_with_retry()
{
    local src_pkg=$1
    local dest_path=$2
    for i in {1..5}; do
        decompress_pkg ${src_pkg} ${dest_path} "$3"
        [[ $? -eq 0 ]] && return 0
        echo "Unzip package: $1 with retry: ${i}"
        sleep 2
    done
    return 1
}

function do_unzip_base_pkg()
{
    if [[ ! -z "${BASE_LOCAL_PKG_PATH}" ]];then
        echo "Unzip base package: ${BASE_LOCAL_PKG_PATH}"
        find ${BASE_LOCAL_PKG_PATH} -exec chmod u+w {} +
        decompress_pkg_with_retry "${BASE_LOCAL_PKG_PATH}" "${DEST_UNZIP_PATH}" || return 13
    fi
    return 0
}

function do_unzip_pack_file()
{
    UNPACKTOOL=${INSTALL_ROOT}/manager/agent/rtsp/jre/bin/unpack200
    files=`find ${DEST_UNZIP_PATH} -name '*.pack' 2>/dev/null`
    for filepath in ${files}
    do
        target_file=${filepath%%%%.pack}
        [[ -f ${target_file} ]] && continue
        ${UNPACKTOOL} ${filepath} ${target_file} || return $?
        rm -f ${filepath} 2>/dev/null
    done
    return 0
}

function do_unzip()
{
    [[ -d ${DEST_UNZIP_PATH} ]] || {
        echo "Make the dest path ${DEST_UNZIP_PATH};"
        mkdir -p -m 750 ${DEST_UNZIP_PATH};
    }

    do_unzip_base_pkg || {
        echo "Unzip base package failed."
        return $?;
    }

    find ${DEST_UNZIP_PATH} -exec chmod u+w {} +
    decompress_pkg_with_retry "${LOCAL_PKG_PATH}" "${DEST_UNZIP_PATH}" || return 11
    [[ "$PKG_TYPE" = 'custom' ]] && {
        find ${DEST_UNZIP_PATH} -exec chmod u+w {} +
        decompress_pkg_with_retry "${LOCAL_PKG_PATH}" "${DEST_UNZIP_PATH}/$PKG_ID" "package/custom_define.json" || return 12;
    }

    do_unzip_pack_file || {
        echo "Unzip jar pack package failed."
        return $?;
    }
    return 0
}

function create_lib_dependfile()
{
    [[ "$PKG_TYPE" = "app" ]] && {
        echo "Create all.lib.dependencies";
        > ${LIB_DEPENDENCY_LIST_FILE}
        > ${RTSP_LIB_DEPENDENCY_LIST_FILE}
        find ${DEST_UNZIP_PATH} -name "*dependencies.list" -a -type f | while read filepath
        do
            LIBDIRPATH=`dirname ${filepath}`
            dos2unix ${filepath} 2>/dev/null
            cat ${filepath} | while read line
            do
                array=(`echo $line | tr ',' ' '`)
                filename=${array[0]}
                digest=${array[1]}
                [[ ${filename##*.} != "jar" && ${filename##*.} != "so" ]] && {
                    flag=$(echo $filename | grep "=")
                    if [[ $flag != "" ]];then
                        rtsp_name=$(echo ${filename%%=*})
                        jar_name=$(echo ${filename#*=})
                        echo ${rtsp_name}=${LIBDIRPATH}/${jar_name} >> ${RTSP_LIB_DEPENDENCY_LIST_FILE}
                    else
                        echo ${LIBDIRPATH}/${filename} >> ${RTSP_LIB_DEPENDENCY_LIST_FILE}
                    fi
                    continue;
                }
                if [[ $digest != "" ]];then
                    [[ ! -f ${LIBDIRPATH}/${filename} ]] && echo ${LIBDIRPATH}/${filename},$digest >> ${LIB_DEPENDENCY_LIST_FILE}
                else
                    [[ ! -f ${LIBDIRPATH}/${filename} ]] && echo ${LIBDIRPATH}/${filename} >> ${LIB_DEPENDENCY_LIST_FILE}
                fi
            done
        done
        chmod 640 ${LIB_DEPENDENCY_LIST_FILE} ${RTSP_LIB_DEPENDENCY_LIST_FILE}
    }
    return 0
}

function init_app_rights()
{
    [ "$PKG_TYPE" = "app" ] && {
        [[ -d ${DEST_UNZIP_PATH}/pub ]] && chmod 750 ${DEST_UNZIP_PATH}/pub 2>/dev/null
        [[ -f ${DEST_UNZIP_PATH}/pub/app_define.json ]] && chmod 640 ${DEST_UNZIP_PATH}/pub/app_define.json 2>/dev/null
        return $?
    }
    return 0
}

function init_custom_rights()
{
    [ "$PKG_TYPE" = "custom" ] && {
        chmod 750 ${DEST_UNZIP_PATH}/${PKG_ID} ${DEST_UNZIP_PATH}/${PKG_ID}/package 2>/dev/null
        chmod 640 ${DEST_UNZIP_PATH}/${PKG_ID}/package/custom_define.json 2>/dev/null
        return $?
    }
    return 0
}

function create_unzip_flag()
{
    touch ${UNZIP_FLAG_PATH} && chmod 640 ${UNZIP_FLAG_PATH}
}

function main()
{
    init_global
    check_unziped
    do_unzip || return $?
    create_lib_dependfile || return $?
    do_rtsp_link || return $?
    export_rtsp_libs || return $?
    init_app_rights || return $?
    init_custom_rights || return $?
    create_unzip_flag || return $?
}

main
exit $?
'''

collect_template = '''
source %(ENGR_PROFILE)s
product=%(PRODUCT_NAME)s
output=%(OUTPUT_FILE)s
> $output

if [ "$product" != "manager" ]; then
    echo "[$product]" >> $output
    ls $INSTALL_ROOT/$product/apps | while read app
    do
        [ `stat -c %%U $INSTALL_ROOT/$product/apps/$app/pub` !=  ossuser ] && continue
        echo app:$app:user:ossuser >> $output
        ls $INSTALL_ROOT/$product/apps/$app | grep unzipflag.txt >> $output
        ls $INSTALL_ROOT/$product/apps/$app/rtsp | while read rtsp
        do
            path=`realpath $INSTALL_ROOT/$product/apps/$app/rtsp/$rtsp`
            echo `basename $path` >> $output
        done
    done
fi
'''
