#!/bin/bash
##################################################
# 功能说明:初始化脚本日志目录
##################################################
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade"
LOG_FILE="${LOG_PATH}/es_up_start.log"
# EasySuite工作目录
ES_WORK_PATH="/opt/oss/easysuite"
# EasySuite保存份数
SAVE_NUMBER=5
# 新版本EasySuite包名
ES_PKG=""

##################################################
# 功能说明:检查脚本执行用户,3001为网管用户ID
##################################################
function check_user()
{
    if [ "$(whoami)" != "$(id -nu 3001)" ]
    then
        echo "The script must be run as the $(id -nu 3001) user."
        exit 1
    fi
}

##################################################
# 功能说明:日志记录方法
##################################################
function LOG()
{
    # 初始化日志目录
    [ ! -d ${LOG_PATH} ] && mkdir -p ${LOG_PATH}

    if [ "$1" = "ERROR" -o "$1" = "error" ]
    then
        Level="ERROR"
    elif [ "$1" = "WARN" -o "$1" = "warn" ]
    then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [$$] | ${Level} $2" | tee -a ${LOG_FILE}

    log_size=$(du -shk "${LOG_FILE}" | awk '{print $1}')
    # 文件大小超过100K,日志压缩重新生成
    if [ ${log_size} -ge 100 ]
    then
        # 压缩文件存在,删除压缩包
        [ -f "${LOG_FILE}.zip" ] && rm -f "${LOG_FILE}.zip"
        # 压缩日志文件
        zip "${LOG_FILE}.zip" ${LOG_FILE}
        # 清空日志文件
        echo >${LOG_FILE}
    fi
    return 0
}

##################################################
# 功能说明:删除EasySuite过期版本
##################################################
function delete_expire_es()
{
    # EasySuite份数
    es_count=0
    for work_path in $(ls -t ${ES_WORK_PATH})
    do
        # 跳过软链接或者非目录
        [ -L "${ES_WORK_PATH}/${work_path}" -o ! -d "${ES_WORK_PATH}/${work_path}" ] && continue
        # 过滤无启停脚本的无效目录
        [ ! -f "${ES_WORK_PATH}/${work_path}/start.sh" ] && continue
        let es_count++
        # 超过最大保存份数,删除多余版本
        if [ ${es_count} -gt ${SAVE_NUMBER} ]
        then
            LOG "INFO" "Start to delete ${ES_WORK_PATH}/${work_path}"
            # 目录递归给写权限,避免无法删除
            chmod -R u+w "${ES_WORK_PATH}/${work_path}"
            rm -rf "${ES_WORK_PATH}/${work_path}"
            LOG "INFO" "Finished to delete ${ES_WORK_PATH}/${work_path}"
        fi
    done
}

#############################################################################
# 功能说明:查找老版本EasySuite_OM包,支撑规避老版本EasySuite版本加载问题
#############################################################################
function find_new_es_pkg()
{
    local old_es_path="${1}"
    local new_es_path="${2}"
    for file_name in $(ls -t ${old_es_path}/var/software | grep -i easysuite | grep -i om | grep -E '.zip$' )
    do
        # 解压版本描述文件和当前EasySuite版本比对,解压失败跳过
        unzip -q ${old_es_path}/var/software/${file_name} easysuite/software_define.yaml -d ${old_es_path}/var/software &>/dev/null && continue
        # 版本描述文件文件不存在跳过
        [ ! -f ${old_es_path}/var/software/easysuite/software_define.yaml ] && continue
        # 版本一致则为正确版本
        diff ${old_es_path}/var/software/easysuite/software_define.yaml ${new_es_path}/easysuite/software_define.yaml && ES_PKG="${file_name}"
        if [ $? -eq 0 ]
        then
            rm -rf ${old_es_path}/var/software/easysuite &>/dev/null
            return 0
        fi
    done
}



