# encoding=utf-8
"""
功 能：查询升级环境配置数据模块
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import json
import os
import sys

from util import httpclient

NODE_LIST_FILE = "/opt/oss/manager/etc/sysconf/nodelists.json"
QUERY_ARB_URL = "/rest/drservice/v1/main/drmgr/custom/queryParam"
QUERY_DR_URL = "/rest/drmgrservice/v1/main/drmgr"


def get_maintenance_ip(node_ip):
    """
    功能说明:获取内部通信IP
    :param node_ip:
    :return:
    """
    with open(NODE_LIST_FILE, 'r') as r_stream:
        file_data = json.load(r_stream)
    maintenance_ip = ""
    maintenance_node_id = ""
    all_maintenance_ips = dict()
    for node_id, node_data in file_data.get('nodeList', {}).items():
        for one_ip in node_data.get('IPAddresses'):
            if "maintenance" in one_ip.get('usage'):
                all_maintenance_ips.update({node_id: one_ip.get('IP')})
            if one_ip.get('IP') == node_ip:
                maintenance_node_id = node_id
        if maintenance_node_id:
            maintenance_ip = all_maintenance_ips.get(maintenance_node_id)
    return maintenance_ip


class QueryData:
    def __init__(self):
        pass

    @staticmethod
    def check_is_dr_connect():
        """
        功能说明:检查容灾是否关联
        :return:
        """
        status, b_response = QueryData.send_get_request(QUERY_DR_URL)
        if status != 200:
            return False
        response = json.loads(b_response)
        if response.get('data'):
            return True
        return False

    @staticmethod
    def check_arb_normal():
        """
        功能说明:检查仲裁是否处于正常状态
        :return:
        """
        # AAMonitor arbiterType:AAMonitor ->  autoswitch_status->OFF
        # arbiterType:doubleMonitor -> autoswitch_status->ON
        # arbiterIp -> 登录对应节点查找IP
        status, b_response = QueryData.send_post_request(QUERY_ARB_URL, 'true')
        if status != 200:
            return True
        response = json.loads(b_response)
        arbiter_type = response.get('arbiterType', '')
        autoswitch_status = response.get('autoswitch_status', 'OFF')
        arbiter_ip = response.get('etcd_servers', '')
        # Case1:
        if not arbiter_ip:
            return True

        # 特定场景
        if (arbiter_type == "AAMonitor" and autoswitch_status == "OFF") \
                or (arbiter_type == "doubleMonitor" and autoswitch_status == "ON"):
            for one_ip in arbiter_ip.split(','):
                one_ip = one_ip[0: one_ip.rfind(':')]
                maintenance_ip = get_maintenance_ip(one_ip)
                if not maintenance_ip:
                    continue
                cmd = f"ssh -o ConnectTimeout=180 -o stricthostkeychecking=no -o " \
                      f"ConnectionAttempts=3 -o ServerAliveInterval=10 {maintenance_ip} " \
                      f"ls /opt | grep arbitration-etcd"
                ret_code = os.system(cmd)
                if ret_code == 0:
                    # 对应站点有仲裁软件
                    return False
        return True

    @staticmethod
    def get_node_ip():
        """
        功能说明:获取节点IP
        :return:
        """
        with open(NODE_LIST_FILE, 'r') as r_stream:
            file_data = json.load(r_stream)
        local_omp01_ip = ""
        for ip_info in file_data.get('nodeList', {}).get("0", {}).get("IPAddresses", []):
            if "maintenance" in ip_info.get("usage", []):
                local_omp01_ip = ip_info.get("IP", "")
                break
        return local_omp01_ip

    @staticmethod
    def send_get_request(url):
        """
        功能说明:发送get请求
        :param url:
        :return:
        """
        status, response = httpclient.IRHttpClient().get(url)
        return status, response

    @staticmethod
    def send_post_request(url, params):
        """
        功能说明:发送post请求
        :param url:
        :param params:
        :return:
        """
        status, response = httpclient.IRHttpClient().post(url, params)
        return status, response


def main(argv):
    """
    根据id和站点角色启动备份管理面
    :return:
    """
    action = argv[1]
    if not action:
        return False
    func_obj = getattr(QueryData, action)
    if len(argv) == 2:
        result = func_obj()
    elif len(argv) == 3:
        result = func_obj(argv[2])
    elif len(argv) == 4:
        result = func_obj(argv[2], argv[3])
    else:
        result = str()
    if os.getenv("es_print") == "true":
        print(result)
    return result


if __name__ == '__main__':
    if main(sys.argv):
        sys.exit(0)
    sys.exit(1)
