#!/bin/bash
# -*- coding:utf-8 -*-

#-----------------------------------------------------------------------------------------------------------------
# func : 检查当前操作系统版本是否为本软件支持的版本
#-----------------------------------------------------------------------------------------------------------------

function get_osnameEX()
{
    local ole_release="/etc/oracle-release"
    local cent_release="/etc/centos-release"
    local rhel_release="/etc/redhat-release"
    local sles_release="/etc/SuSE-release"
    local name=""
    local os_release="/etc/os-release"
    local euler_release="/etc/euleros-release"
    local neokylin_relase="/etc/neokylin-release"
    if [[ -f "${ole_release}" ]]; then
        name="oracle-$(cat "${ole_release}" | awk '{print $5}')"
        echo "$name"
        return 0
    fi
    # 获取Euler的版本, Euleros中存在redhat-release和CentOS-release，最先检查
    if [[ -f "${euler_release}" ]]; then
        if grep -q "release" "${euler_release}"; then
            name="$(cat $euler_release | sed 's/x86_64//g' | awk -F " |SP|)" '{print "euleros-"$3"sp"$5}')"
        else
            name="euleros-$(cat "${euler_release}" | awk '{print $2}' | cut -d "V" -f 2 | tr 'A-Z' 'a-z')"
        fi
        echo "$name"
        return 0
    fi
    if [[ -f "${neokylin_relase}" ]];then
        if grep -q "release" "${neokylin_relase}"; then
            name="$(cat "${neokylin_relase}" | awk '{print $6}' | cut -d "V" -f 2 | tr 'A-Z' 'a-z')"
            if [[ -z "${name}" ]];then
                name="$(cat "${neokylin_relase}" | awk '{print $4}' | cut -d "V" -f 2 | tr 'A-Z' 'a-z')"
            fi
            name="neokylin-$(echo ${name/update/'.'})"
        fi
        echo "$name"
        return 0
    fi
    
    if [[ -f "${os_release}" ]]; then
        #x86_64的suse15系统/etc目录下只有os-release，和以前的“local os_release”做下区分，先判断suse15
        if [[ "suse" = "$(cat "${os_release}" | grep "^ID_LIKE=" | awk -F "\"" '{print $2}')" ]]; then
            name="suse-$(cat "${os_release}" | grep "^VERSION_ID=" | awk -F "\"" '{print $2}')"
            echo "$name"
            return 0
        fi
        
        raw=$(cat "${os_release}")
        eval $raw
        name="$ID-$VERSION_ID"
        echo "$name"
        return 0
    fi
    
    if [[ -f "${cent_release}" ]]; then
        name="centos-$(cat "${cent_release}" | awk '{print $3}')"
        echo "$name"
        return 0
    fi

    if [[ -f "${rhel_release}" ]]; then
        name="redhat-$(cat "${rhel_release}" | awk '{print $7}')"
        echo "$name"
        return 0
    fi
    
    if [[ -f "${sles_release}" ]]; then
        name="suse-$(cat "${sles_release}" | grep "^VERSION" | awk '{print $3}')"
        name="${name}.$(cat "${sles_release}" | grep "^PATCHLEVEL" | awk '{print $3}')"
        echo "$name"
        return 0
    fi
    return 1
}

function is_support_os()
{
    local support="$1"
    local name=""


    if [[ -z "$support" ]]; then
        fn_sys_log_error "${host_ip}: support os list is null."
        return 1
    fi

    name=$(get_osnameEX)

    #当前os类型不属于所支持的os类型
    if [[ $? -ne 0 ]]; then
        fn_sys_log_error "${host_ip}: The OS version is not supported. Currently support ${support}"
        return 1
    fi

    #当前os的版本号不属于所支持的os版本号
    for token in $(echo "${support}" | awk -F ';' '{ for(i=1; i<=NF; i++) print $i }'); do
        if [[ "x${token}" == "x${name}" ]]; then
            echo "${name}"
            return 0
        fi
    done

    echo "${name}"
    fn_sys_log_error "${host_ip}: The OS version is not supported. Currently support ${support}"
    return 1
}

                                      
function check_os()
{
    host_ip=$1
    fn_sys_log_info "${host_ip}: start checking operation system type."
    
    #本软件支持的所有os版本
    support_os="sles-12.4;sles-12.5;euleros-2.0sp9;euleros-2.0sp10;kylin-V10"

    #检查当前os版本是否为本软件支持的os版本
    local_os="$(is_support_os "${support_os}")"
    if [[ $? -ne 0 ]]; then
        echo "$local_os"
        fn_sys_log_error "${host_ip}: The OS version is not supported. Currently support ${support}"
    fi
    fn_sys_log_info "${host_ip}: Success checking operation system type."
}
