#!/bin/bash

################################################
# Usage: check_rpms.sh
#
################################################

###################################################
#
#
###################################################
function get_osname()
{
    local cent_release="/etc/centos-release"
    local ole_release="/etc/oracle-release"
    local rhel_release="/etc/redhat-release"
    local sles_release="/etc/SuSE-release"
    local sles15_release="/etc/os-release"
    local os_release="/etc/os-release"
    local euler_release="/etc/euleros-release"
    local neokylin_relase="/etc/neokylin-release"
    local name=""

    if [[ -f "${euler_release}" ]]; then
        if grep -q "release" "${euler_release}"; then
            name="$(cat $euler_release | sed 's/x86_64//g' | awk -F " |SP|)" '{print "euleros-"$3"sp"$5}')"
        else
            name="euleros-$(cat "${euler_release}" | awk '{print $2}' | cut -d "V" -f 2 | tr 'A-Z' 'a-z')"
        fi
        echo "$name"
        return 0
    fi
    
    if [[ -f "${neokylin_relase}" ]];then
        if grep -q "release" "${neokylin_relase}"; then
            name="$(cat "${neokylin_relase}" | awk '{print $6}' | cut -d "V" -f 2 | tr 'A-Z' 'a-z')"
            if [[ -z "${name}" ]];then
                name="$(cat "${neokylin_relase}" | awk '{print $4}' | cut -d "V" -f 2 | tr 'A-Z' 'a-z')"
            fi
            name="neokylin-$(echo ${name/update/'.'})"
        fi
        echo "$name"
        return 0
    fi
    
    if [[ -f "${cent_release}" ]]; then
        if grep -q "Linux" "${cent_release}"; then
            name="centos-$(cat "${cent_release}" | awk '{print $4}' | awk -F. '{print $1"."$2}')"
        else
            name="centos-$(cat "${cent_release}" | awk '{print $3}')"
        fi
        echo "$name"
        return 0
    fi

    if [[ -f "${ole_release}" ]]; then
        name="oracle-$(cat "${ole_release}" | awk '{print $5}')"
        echo "$name"
        return 0
    fi

    if [[ -f "${rhel_release}" ]]; then
        name="redhat-$(cat "${rhel_release}" | awk '{print $7}')"
        echo "$name"
        return 0
    fi

    if [[ -f "${sles_release}" ]]; then
        name="suse-$(cat "${sles_release}" | grep "^VERSION" | awk '{print $3}')"
        name="${name}.$(cat "${sles_release}" | grep "^PATCHLEVEL" | awk '{print $3}')"
        echo "$name"
        return 0
    fi
    
    if [[ -f "${sles15_release}" ]]; then
        if [[ "suse" = "$(cat "${sles15_release}" | grep "^ID_LIKE=" | awk -F "\"" '{print $2}')" ]]; then
            name="suse-$(cat "${sles15_release}" | grep "^VERSION_ID=" | awk -F "\"" '{print $2}')"
            echo "$name"
            return 0
        fi
		raw=$(cat "${os_release}")
        eval $raw
        name="$ID-$VERSION_ID"
        echo "$name"
        return 0
    fi
    
    return 1
}

################################################
#
#
################################################
function check_rpms()
{
    
    ip=$1
    fn_sys_log_info "${ip}: start checking rpms."
    local must_rpms=""           #ϵͳ�б����е�rpm���б�
    local missing_rpms=""        #���ڱ���ȱʧrpm�б���ļ�
    local osname=""              #os����(suse/redhat)
    local line=""                #�ļ�ÿ�е�����
    local newline=""             #ת������е�����(ȥ�ո�)

    osname="$(get_osname)"
    if [[ $? -ne 0 ]]; then
        fn_sys_log_error "${ip}: get_osname(${osname}) failed."
        fn_sys_log_error "${ip}: Failed to obtain the rpm package."
    fi


    if [[ `uname -p` == "aarch64" ]]; then
       must_rpms="$(dirname "$0")/../../conf/rpm_lists/${osname}_must-rpms-aarch64.lst"
    else
       must_rpms="$(dirname "$0")/../../conf/rpm_lists/${osname}_must-rpms.lst"
    fi
    
    if [[ `uname -p` == "aarch64" ]]; then
       missing_rpms="$(dirname "$0")/../../conf/rpm_lists/${osname}_${ip}_missing-rpms-aarch64.lst"
    else
       missing_rpms="$(dirname "$0")/../../conf/rpm_lists/${osname}_${ip}_missing-rpms.lst"
    fi

    if [[ ! -f "${must_rpms}" ]]; then
        fn_sys_log_error "${ip}: ${must_rpms} is not a file in me."
        fn_sys_log_error "${ip}: Failed to obtain the rpm package."
        return 1
    fi

    echo "# Missing rpms list of host ${ip}" > "${missing_rpms}"
    if [[ $? -ne 0 ]]; then
        fn_sys_log_error "${ip}: ${missing_rpms} is invalid, write failed."
        fn_sys_log_error "${ip}: Failed to obtain the rpm package."
        return 1
    fi

    echo "# This list was generated on $(date)" >> "${missing_rpms}"
    echo "# os: ${osname}" >> "${missing_rpms}"

    while read line
    do
        if [[ -z "$(echo "$line" | grep "^[[:alnum:]]")" ]]; then
            continue
        fi

        newline="$(echo "$line" | tr -d '[:space:]')"

        version=$(rpm -q "${newline}")
        if [[  $? -ne 0 ]]; then
            echo "${newline}" >> "${missing_rpms}"
            fn_sys_log_error "${ip}: need to install : ${newline}"
        else
            #ver=$(echo $version |cut -f2 -d '-')
            echo "[RPM_VER]#${ip}#${newline}#${version}"
        fi
        
    done < "${must_rpms}"

    echo "" >> "${missing_rpms}"
    fn_sys_log_info "${ip}: End checking rpms."
}
