#!/bin/bash
. ./controller.sh
################################################################################
# Function    : check_ntp_config
# Description : check the ntp config is right.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_ntp_config()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    # lld_outer_ntp_mmvalue,lld_outer_ntp_mmvalue_bak_1,lld_outer_ntp_mmvalue_bak_2

    cd /root/EasySuite/888/script/
    res_ntp_config=$(/root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.install.check_items_interact -check_item "install.check_ntp_config" <<eof
${lld_outer_ntp_mmvalue}
${lld_outer_ntp_mmvalue_bak_1}
${lld_outer_ntp_mmvalue_bak_2}
eof
)
    if [[ $? == 0 ]]
    then
        echo "custom_check_ntp_config"
        echo " "
        echo "-----------------------------------------------------"
        echo "[successfully]The NTP configuration meets installation specifications, please continue."
        echo "-----------------------------------------------------"
        echo " "
    else
        echo "custom_check_ntp_config"
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]The NTP configuration not meets installation specifications, please confirm it."
        IFS=$'@'
        echo ${res_ntp_config#'es_input: lld_outer_ntp_mmvaluees_input: lld_outer_ntp_mmvalue_bak_1es_input: lld_outer_ntp_mmvalue_bak_2'}
        echo "-----------------------------------------------------"
        echo " "
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    else
        return 0
    fi
}
