#!/bin/bash

CUR_PATH=$(cd `dirname $0`;pwd)
cd ${CUR_PATH}
. ./controller.sh
. ./check_memory.sh
. ./check_io.sh
. ./check_iops.sh
. ./check_cpu.sh
. ./check_disk.sh
. ./check_partition_volume.sh
. ./check_os_version.sh
. ./check_install.sh
. ./check_user.sh
. ./check_service_status.sh
. ./check_network_config.sh
. ./check_node_network_segment.sh
. ./check_feature.sh
. ./check_os_time.sh

################################################################################
# name    :    main
# describe:    main function of check environment about MDSP
# parameter list: null
# input      : null
# output  : 0 success 1 failure
# rerurn  : null
# invoker : main
################################################################################
#step1: check Partition

function main()
{
    #the variable count the fail time of check step
    typeset -i fail_num=0
    # generate conf to param
    flag_file=/root/EasySuite/888/conf/config.properties

    #CPU arch
    cpu_arch_log='/opt/install_check/check_cpu_arch.log'
    cat ${cpu_arch_log}

    # 检查客户服务器安装的操作系统及版本是否满足要求
    echo "custom_check_os_version"
    check_os_version
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        echo "[successfully] Checking os type successfully !"
    fi
    echo "custom_check_os_version"

    #step0: 主节点和扩容节点 都执行网络检查
    check_network_config
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
    else
        echo "[successfully] Checking network config successfully !"
    fi
    echo "custom_check_init_network_config"

    #特性检查
    if [[ $2 == "main_fi_fabric" ]]
    then
        echo "custom_check_feature_check"
        check_feature
        if [ $? -ne 0 ]
        then
            ((fail_num=fail_num+1))
        else
            echo "[successfully] Checking feature successfully !"
        fi
        echo "custom_check_feature_check"
    fi

    # 扩容节点
    if [[ $2 == "scale_node" ]]
    then

        #step2: 检查客户服务器内存规格是否满足要求
        echo "custom_check_memory"
        check_memory
        if [ $? -ne 0 ]
        then
            ((fail_num=fail_num+1))
        else
            echo "[successfully] Checking left memory successfully !"
        fi
        echo "custom_check_memory"

        #step3: 检查客户服务器io是否满足要求
        echo "custom_check_disk_io"
        check_io
        if [ $? -ne 0 ]
        then
            ((fail_num=fail_num+1))
        else
            echo "[successfully] Checking io successfully !"
        fi
        echo "custom_check_disk_io"

        #step3.2: 检查客户服务器IOPS是否满足要求
        echo "custom_check_node_disk_iops"
        check_iops
        if [ $? -ne 0 ]
        then
            ((fail_num=fail_num+1))
        else
            echo "[successfully] Checking iops successfully !"
        fi
        echo "custom_check_node_disk_iops"

        #step4: 检查客户服务器cpu是否满足要求
        echo "custom_check_cpu_core"
        check_cpu
        if [ $? -ne 0 ]
        then
            ((fail_num=fail_num+1))
        else
            echo "[successfully] Checking Number of CPU cores successfully !"
        fi
        echo "custom_check_cpu_core"

        #step5: 检查客户服务器磁盘规格是否满足要求
        echo "custom_check_disk_space"
        check_disk
        if [ $? -ne 0 ]
        then
            ((fail_num=fail_num+1))
        else
            echo "[successfully] Checking disk successfully !"
        fi
        echo "custom_check_disk_space"

        #step6: 检查客户服务器磁盘分区是否满足要求
        echo "custom_check_partition"
        check_partition_volume
        if [ $? -ne 0 ]
        then
            ((fail_num=fail_num+1))
        else
            echo "[successfully] Checking disk partition successfully !"
        fi
        echo "custom_check_partition"

        #step8: 检查客户服务器是否有产品残留目录和文件
        echo "custom_check_installed"
        check_install
        if [ $? -ne 0 ]
        then
            ((fail_num=fail_num+1))
        else
            echo "[successfully] Checking the product is installed successfully !"
        fi
        echo "custom_check_installed"

        #step9: 检查客户服务器上是否有产品残留用户
        echo "custom_check_user_exits"
        check_user
        if [ $? -ne 0 ]
        then
            ((fail_num=fail_num+1))
        else
            echo "[successfully] Checking no expected users successfully !"
        fi
        echo "custom_check_user_exits"

        #step10: 检查客户服务器上是否有不同网口上的网段有重叠的情况
        echo "custom_check_node_network_segment"
        check_node_network_segment
        if [ $? -ne 0 ]
        then
            ((fail_num=fail_num+1))
        fi
        echo "custom_check_node_network_segment"

        #step13: 检查客户服务器上操作系统时间是否正常
        echo "custom_check_os_time"
        check_os_time
        if [ $? -ne 0 ]
        then
            ((fail_num=fail_num+1))
        fi
        echo "custom_check_os_time"

    else
        #step10: 在主节点上检查业务节点的状态是否正常
        echo "custom_check_service_status"
        check_service_status
        if [ $? -ne 0 ]
        then
            ((fail_num=fail_num+1))
        else
            echo "[successfully] Checking service status successfully !"
        fi
        echo "custom_check_service_status"
    fi

    if [ ${fail_num} -gt 0 ]
    then
        echo "===========================CHECKING ENVIRONMENT FAILED=============================="
        echo "===================================================================================="
        echo 'check_env_sh_flag=1' >> ${flag_file}
        return 1
    else
        echo "===========================CHECKING ENVIRONMENT SUCCESSFULLY========================"
        echo "===================================================================================="
        echo 'check_env_sh_flag=0' >> ${flag_file}
        return 0
    fi
}

# os_pwd_root
IFS=$'\n'
echo "es_input: os_pwd_root"
read -sr os_root_user_pwd


#execute main function
main "$@"
