# How Do I Verify Downloaded Software Packages Using the PGPVerify Software?<a name="EN-US_TOPIC_0000001471456686"></a>

## Question<a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_se1627f773e384a5bafcc3f7958cf9e2c"></a>

How do I verify downloaded software packages using the PGPVerify software?

## Answer<a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_sb0fffc6c4cd340fc9bdebf61caf326b4"></a>

**Prerequisites**

-   Software packages and signature files correspond to each other and are stored in the same directory. A software package corresponds to a signature file. Signature files are released with products and their software packages.
-   Signature files are in .asc format and share names with their software packages. For example, if the name of a software package is  **V100R023C00.zip**, the name of its signature file is  **V100R023C00.zip.asc**.

    >![](public_sys-resources/icon-note.gif) **NOTE:** 
    >Click  ![](figures/en-us_image_0277665120.png)  to download .asc files.

-   Obtain the PGPVerify tool that is used to verify the integrity of downloaded software packages and its public key file  **KEYS**  or  **KEYS.txt**.
    1.  Download PGPVerify and its public key file  **KEYS**  or  **KEYS.txt**.
        -   For carriers, log in to  [https://support.huawei.com/carrier/digitalSignatureAction](https://support.huawei.com/carrier/digitalSignatureAction), download and decompress the  **OpenPGP Signature Verification Guide**  package to obtain the  **PGPVerify.zip**  package and its public key file  **KEYS**. Decompress  **PGPVerify.zip**  to obtain the  **PGPVerify.jar**  and  **StartUp.vbs**  files.
        -   For enterprises, log in to  [https://support.huawei.com/enterprise/en/huawei-cloud-service/pgpverify-pid-22562161/software](https://support.huawei.com/enterprise/en/huawei-cloud-service/pgpverify-pid-22562161/software)  and download the latest  **PGPVerify.zip**  and  **KEYS.txt**. Decompress  **PGPVerify.zip**  to obtain the  **PGPVerify.jar**  and  **StartUp.vbs**  files.

    2.  On Linux OS, use SFTP to upload the obtained PGPVerify software and public key file  **KEYS**  or  **KEYS.txt**  to the server. For details about the SFTP transfer method, see  [Transferring Files Using FileZilla](transferring-files-using-filezilla.md).
    3.  Windows OS supports GUI-based verification and CLI-based verification. Linux OS supports CLI-based verification only.

-   PGPVerify is a digital signature verification tool released by Huawei. Users can select third-party openPGP verification tools as needed.

    <a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_t52fb581fd2294d10b3dcbe1e36611445"></a>
    <table><thead align="left"><tr id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_r13abf7e39eec46d3b33c61158d20a0b0"><th class="cellrowborder" valign="top" width="22.62%" id="mcps1.1.4.1.1"><p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a28e4eb6893bd4c53bee7432deee3b927"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a28e4eb6893bd4c53bee7432deee3b927"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a28e4eb6893bd4c53bee7432deee3b927"></a>Tool</p>
    </th>
    <th class="cellrowborder" valign="top" width="16.42%" id="mcps1.1.4.1.2"><p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_acfadcd847ab041a9ad606dfd23a97b38"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_acfadcd847ab041a9ad606dfd23a97b38"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_acfadcd847ab041a9ad606dfd23a97b38"></a>OS</p>
    </th>
    <th class="cellrowborder" valign="top" width="60.96%" id="mcps1.1.4.1.3"><p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_ad5304a880a954f9c9e6d58383e774e61"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_ad5304a880a954f9c9e6d58383e774e61"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_ad5304a880a954f9c9e6d58383e774e61"></a>Tool Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_rc7abd5962bf84e4c999e07ae8747abeb"><td class="cellrowborder" valign="top" width="22.62%" headers="mcps1.1.4.1.1 "><p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a13b291d7164d4676a5fd43d5a5621400"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a13b291d7164d4676a5fd43d5a5621400"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a13b291d7164d4676a5fd43d5a5621400"></a>PGPVerify</p>
    </td>
    <td class="cellrowborder" valign="top" width="16.42%" headers="mcps1.1.4.1.2 "><p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a657a3cefacad404cb9e090f446defd4e"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a657a3cefacad404cb9e090f446defd4e"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a657a3cefacad404cb9e090f446defd4e"></a>Windows/Linux</p>
    </td>
    <td class="cellrowborder" valign="top" width="60.96%" headers="mcps1.1.4.1.3 "><p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a290e53800b794cb3845a45e0a1407334"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a290e53800b794cb3845a45e0a1407334"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a290e53800b794cb3845a45e0a1407334"></a>It is a simple PGP verification tool released by Huawei.</p>
    </td>
    </tr>
    <tr id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_r3246b16ced23461aaeeb946783d631ad"><td class="cellrowborder" valign="top" width="22.62%" headers="mcps1.1.4.1.1 "><p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a433b908c18b64ff89ddbbd4ce0d761dd"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a433b908c18b64ff89ddbbd4ce0d761dd"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a433b908c18b64ff89ddbbd4ce0d761dd"></a>GNU Privacy Guard for Windows (Gpg4Win)</p>
    </td>
    <td class="cellrowborder" valign="top" width="16.42%" headers="mcps1.1.4.1.2 "><p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a52990dfa4c664a95a66b044253a317a1"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a52990dfa4c664a95a66b044253a317a1"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a52990dfa4c664a95a66b044253a317a1"></a>Windows</p>
    </td>
    <td class="cellrowborder" valign="top" width="60.96%" headers="mcps1.1.4.1.3 "><p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_aa4defc25dac64f1a81497eb317e6e800"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_aa4defc25dac64f1a81497eb317e6e800"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_aa4defc25dac64f1a81497eb317e6e800"></a>It is an official version of GnuPG for Windows OSs.</p>
    <p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a673c4f66a0424ae4a6b0bdfbbc777b05"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a673c4f66a0424ae4a6b0bdfbbc777b05"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a673c4f66a0424ae4a6b0bdfbbc777b05"></a>Official website: <a href="https://www.gpg4win.org/" target="_blank" rel="noopener noreferrer">https://www.gpg4win.org/</a></p>
    <p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a1df5659152c94486a557d1d723fd32ec"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a1df5659152c94486a557d1d723fd32ec"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a1df5659152c94486a557d1d723fd32ec"></a>Recommended version: 2.2.1</p>
    </td>
    </tr>
    <tr id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_r5850621663d44b1a85753d1e8fba9973"><td class="cellrowborder" valign="top" width="22.62%" headers="mcps1.1.4.1.1 "><p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a3de765e339ae46b096325c1a3202e7ce"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a3de765e339ae46b096325c1a3202e7ce"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a3de765e339ae46b096325c1a3202e7ce"></a>The GNU Privacy Guard (GnuPG)</p>
    </td>
    <td class="cellrowborder" valign="top" width="16.42%" headers="mcps1.1.4.1.2 "><p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a52d8314ccdaa4b1791a4b9a91f7a8d48"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a52d8314ccdaa4b1791a4b9a91f7a8d48"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a52d8314ccdaa4b1791a4b9a91f7a8d48"></a>Linux</p>
    </td>
    <td class="cellrowborder" valign="top" width="60.96%" headers="mcps1.1.4.1.3 "><p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a5f50162e16a541d28fe3d2d0bf80b7ff"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a5f50162e16a541d28fe3d2d0bf80b7ff"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a5f50162e16a541d28fe3d2d0bf80b7ff"></a>It is a free and source-open GNU tool that implements the OpenPGP standard defined by the RFC4880 protocol. This tool is pre-installed on most Linux OSs.</p>
    <p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a92e1355285ea402982c44882e96fe390"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a92e1355285ea402982c44882e96fe390"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_a92e1355285ea402982c44882e96fe390"></a>Official website: <a href="https://www.gnupg.org/" target="_blank" rel="noopener noreferrer">https://www.gnupg.org/</a></p>
    <p id="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_add54bdbf07b74710ac81e67a45488bff"><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_add54bdbf07b74710ac81e67a45488bff"></a><a name="en-us_topic_0000001298426434_en-us_topic_0000001309595377_en-us_topic_0274871727_en-us_topic_0266396717_en-us_topic_0263041905_en-us_topic_0171399295_en-us_topic_0159113282_en-us_topic_0158065582_add54bdbf07b74710ac81e67a45488bff"></a>Recommended version: 2.0.9</p>
    </td>
    </tr>
    </tbody>
    </table>


**Procedure**

1.  Verify software correctness by referring to  _OpenPGP Signature Verification Guide_. If the verification fails, do not use the package and contact  Huawei technical support.

