#!/bin/bash
. ./controller.sh
################################################################################
# Function    : check_probe_name
# Description : check the probe name not repeat.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_probe_name()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    cd /root/EasySuite/888/script/
    res_probe_name=$(/root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.install.check_items -check_item "scale.check_probe_name")
    if [[ $? == 0 ]]
    then
        echo " "
        echo "-----------------------------------------------------"
        echo "[successfully]The probe name check success, please continue."
        echo "-----------------------------------------------------"
        echo " "
    else
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]The probe name can not repeat, please confirm it."
        IFS=$'@'
        if  [ ! "${res_probe_name}" ]; then
            echo "[ERROR message]: Execution exception."
            echo "[Solution]: Please go to the /var/log/insight/install/ directory to view logs."
            echo "-----------------------------------------------------"
            echo " "
        else
            echo ${res_probe_name}
            echo "-----------------------------------------------------"
            echo " "
        fi
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    else
        return 0
    fi
}
