#!/bin/bash
. ./controller.sh
################################################################################
# Function    : check_product
# Description : check product type.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_product()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    product_name=$(cat /opt/oss/manager/etc/sysconf/nodelists.json | grep -E 'FabricInsight|CampusInsight|SOP' | head -n 1| awk -F "[:]" '/assignedToTenancy/{print$2}' | awk -F "[\"\"]" '{print$2}')
    echo $1 | grep ${product_name} > /dev/null 2>&1
    if [[ $? != 0 ]]
    then
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]The product is error, please confirm the product."
        echo "-----------------------------------------------------"
        echo " "
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    cat /opt/oss/manager/var/etc/common/custom.cfg | grep "SYSTEM_VERSION" | awk -F'=' '{print
    $2}' | grep "V100R022C10SPC100.*" > /dev/null 2>&1
    if [[ $? != 0 ]]
    then
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]"
        echo "[ERROR message]: The version of product is error, please confirm the version."
        echo "-----------------------------------------------------"
        echo "[Solution]: For details, see the product documentation of the current product version."
        echo "-----------------------------------------------------"
        echo " "
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    fi

    echo " "
    echo "-----------------------------------------------------"
    echo "[successfully]The product and version is right, please continue."
    echo "-----------------------------------------------------"
    echo " "

    return 0
}
