#!/bin/bash
. ./controller.sh
################################################################################
# Function    : check_disk_space
# Description : check disk space total capacity.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_disk_space
{
    if [ "X${disk_size}" == "X" ];then
		print_log "WARNING" "Disk size to be checked is not configured, skip check disk size."
        return 0
    fi
    warn_root_disk_size=0
    error_root_disk_size=0
	total_disk_size=0
    total_space_list=`lsblk -lb -o NAME,SIZE,TYPE | awk '{if($3 == "disk")print $2}'`
    total_space=0
    for disk_space in ${total_space_list}
    do
		disk_space="${disk_space}B"
        local tmp_size=`fn_get_size_GB ${disk_space}`
        total_space=`echo ${total_space}+${tmp_size} | bc`
    done
	if [ "X${add_disk}" == "X" ];then
		add_disk=0
	fi	
	total_disk_size=`echo ${disk_size}+${add_disk} | bc`
    if [[ `echo "${total_space} < ${total_disk_size}" | bc` -eq 1 ]];then
		print_log "ERROR" "The total disk space is ${total_space}G, less than ${total_disk_size}G."
		print_log "ERROR" "Please increase disk space and then install again."
        return 1
    else
		print_log "INFO" "Disk size check successfully. The total disk space of the install directory is ${total_space}G, expected disk size is ${total_disk_size}G."
        return 0
    fi
}

