#!/bin/bash
. ./controller.sh
################################################################################
# Function    : check_vmname_hostname
# Description : check the vmname_hostname.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_vmname_hostname
{
    vmname=$hostname
    hostName=`hostname`
    if [ "X${vmname}" == "X" ]; then
        echo "[vmname_hostname check warning] Expected vmname_hostname is not provided in the configuration file, skip check vmname_hostname" >&1
        return 0
    fi
    if [[ "$vmname" != "$hostName" ]]; then
        echo "[vmname_hostname check failed]vmNodeName ${vmname} is not same with hostname ${hostName}"
        echo " " >&2
        return 1
    fi
    echo "[INFO]vmname is ${vmname},hostname is ${hostName}."
    return 0
}