#!/bin/bash

checkOS()
{
  OSType=""
  if [ -f /etc/SuSE-release ]
  then
    OSType="suse"
  elif [ -f /etc/centos-release ] && [ "`grep CentOS /etc/centos-release`"]
  then
    OSType="centos"
  elif [ -f /etc/euleros-release ]
  then
    OSType="EulerOS"
  elif [ -f /etc/rethad-release ]
  then
    OSType="redhatOS"
  else
    OSType="others"
  fi

  if [ "${OSType}" != "EulerOS" ]
  then
    return 1
  fi

  return 0
}

#############################################
# 初始函数校验
#############################################
function verify_params()
{
    INSTALL_TYPE=$1
    echo "Start verify install type params: ${INSTALL_TYPE}."
    local params_list=('noinstall' 'carrier' 'campus')
    local flag=0
    for param in "${params_list[@]}";do
        if [[ "${param}" == "${INSTALL_TYPE}" ]];then
            flag=$((flag+1))
        fi
    done
    if [[ ${flag} -eq 1 ]];then
        echo "The parameter is verified successfully."
        return 0
    fi
    echo "The parameter is incorrect, not in the list: ${params_list[@]}"
    return 1
}

reboot_os()
{
    [ ! -d "/opt/commissioning" ] && mkdir -p "/opt/commissioning"
    #生成系统启动项脚本
    echo "#!/bin/bash
    logger -p local0.info \"reboot_os.sh;Successful;Start reboot_os.sh successful\"
    echo \"reboot  successfully.\" > /opt/commissioning/reboot.flag
    logger -p local0.info \"reboot_os.sh;Successful;reboot_os.sh execute successful.\"
    " >/opt/commissioning/reboot_os.sh
    chmod 750 /opt/commissioning/reboot_os.sh

    #设置系统启动项
    grep 'reboot_os.sh' /etc/rc.d/rc.local >/dev/null 2>&1
    [ $? -ne 0 ] && echo "bash /opt/commissioning/reboot_os.sh" >> /etc/rc.d/rc.local
    chmod +x  /etc/rc.d/rc.local
    service sshd stop
    sleep 10
    sync;sync;sync;sync

    #重启操作系统
    shutdown -r now
}

Main()
{
    checkOS
    if [ $? -ne 0 ]
    then
      rm -rf /opt/commissioning/os_patch/ > /dev/null 2>&1
      echo "No patch is required for non-EulerOS."
      return 0
    fi
    # 清除os重启标识
    if [ -f "/opt/commissioning/reboot.flag" ];then
        rm -rf "/opt/commissioning/reboot.flag"
    fi

    temp1="/opt/commissioning/os_patch/temp1"
    temp2="/opt/commissioning/os_patch/temp2"
    temp3="/opt/commissioning/os_patch/temp3"
    mkdir -p ${temp1} ${temp2} ${temp3}

    pkg_os_patch_euler=$1
    INSTALL_TYPE=$2
    if [ -z "${INSTALL_TYPE}" ];then
        INSTALL_TYPE="carrier"
    fi
    verify_params "${INSTALL_TYPE}" || return 1

    cd /opt/commissioning/os_patch/
    tar -xvf ${pkg_os_patch_euler} -C ${temp1} > /dev/null 2>&1

    cd ${temp1}/
    tar -zxvf *.tar.gz -C ${temp2} > /dev/null 2>&1

    cd ${temp2}/
    tar -zxvf *.tar.gz -C ${temp3} > /dev/null 2>&1

    cd ${temp3}/
    cd $(find . -name *Patch -type d)/
    tar xvf os_sudobin_pkg.tar > /dev/null 2>&1
    tar xvf os_sudobin.tar > /dev/null 2>&1
    cd script/
    bash update_euler_do.sh --product ${INSTALL_TYPE}

    if [ $? -ne 0 ]
    then
        echo "Error: config EulerOS patch package failed" 1>&2
        return 1
    else
        echo "config EulerOS patch package succeed"
    fi

    rm -rf /opt/commissioning/os_patch/ > /dev/null 2>&1

    return 0
}

Main $*
res_os_patch=$?
if [ ${res_os_patch} -eq 0 ];then
    echo "The value is ${res_os_patch}, executed successful, ready to reboot the OS"
    reboot_os
else
    echo "The value is ${res_os_patch}, executed failed"
fi
