#!/bin/bash

USER_LIST="root ossadm ossuser ftpuser dbuser iscript secuser"

# 安全要求，刷新指定目录下权限
function post_chmod()
{
    #控制文件权限
    find /opt/tools -type f -name "*.sh" | xargs -i echo '"{}"' | xargs chmod 550

    targetDir="/opt/SEK"
    if [ -d "$targetDir" ];then
        find $targetDir -type f -name "*.log" -o -name "*.sh.log*" | xargs -i echo '"{}"' | xargs chmod 640
        find $targetDir -type f -name "*.xml" -o -name "*.properties" -o -name "*.conf" -o -name "*.ini" | xargs -i echo '"{}"' | xargs chmod 400
        find "${targetDir}" -type f -name "*.json" -o -name "*.xml" -o -name "*.txt" -o -name "*.conf" -o -name "*.properties" -o -name "*.csv" | xargs -L 1 chmod 400 >/dev/null 2>&1
    fi
}

# 处理端口监听以及南向网口
function deal_port_south() {
    if [ -f "/opt/oss/manager/adapter/common/resmgr/init_config.sh" ]
    then
        su - ossadm -c "cd /opt/oss/manager/adapter/common/resmgr && bash init_config.sh"
        if [ $? -ne 0 ]
        then
            return 1
        fi
    fi
}

# 处理业务用户相关设置
function deal_user_config() {
    chage -M 99999 omm >/dev/null 2>&1
    chage -M 99999 ommdba >/dev/null 2>&1
    for username in ${USER_LIST}; do
        id ${username} >/dev/null 2>&1
        if [ $? -eq 0 ];then
            # 修改密码不过期
            chage --maxdays 99999 ${username}
            # 修改密码修改最小间隔时间7天
            chage --mindays 7 ${username}
            # 修改密码过期前7天提醒
            chage --warndays 7 ${username}
            # 修改密码过期后用户锁定时间为30天
            chage --inactive 30 ${username}
        fi
    done
    # sopuser mindays设置
    chage --mindays 7 sopuser
    chage -I -1 sopuser
}

# 返回值0: 运行正常
# 返回值1: 步骤失败
function main()
{
    # 执行目录权限刷新
    post_chmod >/dev/null 2>&1

    # 南向ip禁用脚本 && 22端口监听
    deal_port_south || return 1

    # 防止sshd服务在5s内重启次数过多
    sleep 10

    # 设置用户相关配置
    deal_user_config

    #选择启用安全加固时，禁用root SSH登陆
    if [ -f "/opt/SEK/RunSEK.sh" ];then
        cd /opt/SEK;bash RunSEK.sh
        local lockResult=$?
        if [[ ${lockResult} != 0 ]]
        then
            # 加固不成功,解加固后再退出
            cd /opt/SEK/cmd;bash SetEnv.sh >/dev/null 2>&1
            return 1
        fi
    fi
}

main $*
exit $?
