#!/bin/bash

###########################################################################
#
# Author: 
#
# Version: 1.0
#
# Description: 
#
# Others:
#
# History:
#    Modification: Create the file
#
###########################################################################

#---------------------------------------------------------------------------
#  Function:    get_os_version
#  Description: 0: not redhat
#               6: redhat 6
#                7: redhat 7
#  Input:       NA
#  Output:      NA
#  Return:      NAvi ni    
#  Others:      NA
#---------------------------------------------------------------------------
function get_os_version
{
    if [ -e /etc/SuSE-release ]
    then
        grep "VERSION = 11" /etc/SuSE-release >/dev/null
        if [ $? -eq 0 ]; then
            return 11
        fi
    fi
    if [ -e /etc/centos-release ]
    then
        grep "CentOS release 6.2" /etc/centos-release >/dev/null
        if [ $? -eq 0 ]; then
            return 2
        fi
        cat /etc/centos-release | grep "CentOS" | grep "release 7" >/dev/null
        if [ $? -eq 0 ]; then
            return 77
        fi
        
    fi
    if [ -e /etc/redhat-release ]
    then
       cat /etc/redhat-release |  grep "Red Hat" | grep "release 6" >/dev/null
       if [ $? -eq 0 ]
       then
          return 6
       fi
       cat /etc/redhat-release |  grep "Red Hat" | grep "release 7" >/dev/null
       if [ $? -eq 0 ]
       then
          return 7
       fi
    fi
    if [ -e /etc/os-release ]
    then
        cat /etc/os-release |  grep "SUSE" | grep "12"
        if [ $? -eq 0 ]
        then
            echo "OS is SUSE 12"
            return 12
        elif 
            cat /etc/os-release |  grep "Euler" 
        then
            echo "OS is EulerOS"
            return 13
        elif cat /etc/os-release | grep "Kylin"; then
            echo "OS is KylinOS"
            return 14
        fi
    fi
    echo "Unsupport OS."
    exit 1
}


#---------------------------------------------------------------------------
#  Function:    get_os_type
#  Description: 0: not redhat
#               6: redhat 6
#                7: redhat 7
#  Input:       NA
#  Output:      NA
#  Return:      NAvi ni    
#  Others:      NA
#---------------------------------------------------------------------------
function get_os_type
{
    if [ -e /etc/SuSE-release ]
    then
        linux_type="SUSE"
    fi
    if [ -e /etc/centos-release ] 
    then
        cat /etc/centos-release |grep "CentOS" >/dev/null
        if [ $? -eq 0 ]
        then
            linux_type="CentOS"
        fi
    fi
    if [ -e /etc/redhat-release ] 
    then
        cat /etc/redhat-release |grep "Red Hat" >/dev/null
        if [ $? -eq 0 ]
        then
            linux_type="Redhat"
        fi
    fi
    if [ -e /etc/euleros-release ] 
    then
        cat /etc/euleros-release  |grep "Euler" >/dev/null
        if [ $? -eq 0 ]
        then
            linux_type="EulerOS"
        fi
    fi
    if [ -e /etc/kylin-release ]; then
        cat /etc/kylin-release | grep "Kylin" >/dev/null
        if [ $? -eq 0 ]; then
            linux_type="KylinOS"
        fi
    fi
    return
}

get_os_version
version=$?
get_os_type