#!/bin/bash
#==============================================================
# Copyright  Huawei Technologies Co., Ltd. 1998-2012. All rights reserved.
# File Name             : setLocalHostname.sh
# Version:Data          : 16-08-2012  
# Description           : modify hostname for OSMU and HOST
# Others                : 
# History               : 
#==============================================================


MODULE_NAME="`basename $0 | sed 's/.sh//g'`"
RELATIVE_PATH="`dirname $0`"

#get absolute path 
cd "${RELATIVE_PATH}"
ABSOLUATELY_PATH=`pwd`

#import common variable..
. ../common/error_code.sh
. ../common/common.sh
cd - >/dev/null 2>&1

function fn_remove_tmp_file()
{
    [ -d "${TMP_CONFIG_PATH}" ] && rm -rf "${TMP_CONFIG_PATH}"/tmp*
    [ ${MAIN_RET} -eq 0 ] && [ -d "${LOGPATH}/backup${GLOBAL_BASH_PID}" ] && rm -rf "${LOGPATH}/backup${GLOBAL_BASH_PID}"
    return ${SUCCESS_CODE}
}


# Name        : fn_write_operation_log
# Description : write operation log
# Parameters  : $1 return value

function fn_write_operation_log()
{
    local RETCODE=$1
    who am i | egrep -w '([0-9]{1,3}\.){3}([0-9]{1,3})' &> /dev/null 
    if [ $? -eq 0 ]
    then
        OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
        OPERIP="${OPERIP//:*/}"
    else
        OPERIP=''
    fi
    
    if [ "${RETCODE}" = 0 ]
    then
        echo "`date` `hostname` `whoami` setLocalHostname.sh;Successful;set Hostname Successfully." >> /var/log/localmessages
        echo "Modify Hostname Successfully. "
    else
        echo "`date` `hostname` `whoami` setLocalHostname.sh;Failed;set Hostname System Failed." >> /var/log/localmessages
        echo "Modify Hostname ... failure"
    fi    
    chmod 640  /var/log/localmessages

    return 0
}



#==============================================================
## @Usage func_name 
## @Return ${SUCCESS_CODE}
## @Description This function backup hostname config file
#==============================================================
fn_backup_file()
{
    #define local variable
    local host_old_name="$1"
    local host_file="$2"

    local bakcup_dir="${LOGPATH}/backup${GLOBAL_BASH_PID}/${host_old_name}"
    #backup hostname configuration file
    PRINT_LOG "INFO" "Begin to backup hostname configuration file ..."
    
    mkdir -p "${bakcup_dir}"
    for file in ${host_file}
    do
        if [ ! -f "${file}" ]
        then
            PRINT_LOG "FATAL" "Backup hostname configuration file... failure"
            return "${ERR_FILEEXIST}"
        fi

        cp -a "${file}" "${bakcup_dir}" &>/dev/null
        if [ $? -ne 0 ]
        then
            PRINT_LOG "FATAL" "Backup hostname configuration file... failure"
            return "${ERR_EXECSYS}"
        fi
    done
 
    PRINT_LOG "INFO" "Backup hostname configuration file... Ok"
    return "${SUCCESS_CODE}"
}

function fn_modify_files()
{
    local host_old_name=$1
    local host_new_name=$2
    local host_file="$3"
    
    local host_ip
    
    
    for file in ${host_file}
    do
        if [ "${file}" = "/etc/hosts" ]
        then
            #Note: modify /etc/hosts file, if the old hostname do not in this file, no need to handle this file 
            host_ip=`grep -w "${host_old_name}" "${file}" |awk '{print $1}'`
            if [ -z "${host_ip}" ] 
            then
                PRINT_LOG "WARN" "Record not found or the host name and the /etc/hosts is inconsistent the records kept by"
                continue
            fi

            for ip in ${host_ip}
            do
                [ -z "${ip}" ] && continue
                sed -i -r "s#^([[:space:]]*${ip}[[:space:]]*).*#\1${host_new_name}#g" "${file}"
            done
        elif [ "${file}" = "/etc/HOSTNAME" ]
        then
            #Note: modify /etc/HOSTNAME 
            sed -i --follow-symlinks "s#^${host_old_name}.*#${host_new_name}#g" "${file}" &> "${TMP_CONTENT_FILE}" || { ret=1; break; }
            grep "^${host_new_name}" "${file}" > /dev/null 2>&1
            [ $? -ne 0 ] && echo "${host_new_name}" > "${file}"
        fi
        
        #Note: check the file
        grep -w "${host_new_name}" "${file}" > /dev/null 2>&1
        if [ $? -ne 0 ]
        then
            PRINT_LOG "FATAL" "Modify hostname file for ${host_ip}... failure"
            PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
            return ${ERR_EXECSYS}
        fi
        PRINT_LOG "INFO" "Modify hostname file for ${host_ip}... OK"
    done

    if [ "${ret}" = "1" ]
    then
        PRINT_LOG "FATAL" "modify hostname file for ${host_ip}... failure"
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
        return ${ERR_EXECSYS}
    fi
    PRINT_LOG "INFO" "Modify hostname file for ${host_ip}... Ok"
    
    hostname ${host_new_name} &>/dev/null
    if [ $? -ne 0 ]
    then
        PRINT_LOG "FATAL" "Exec <hostname ${host_new_name}>... failure"
        return ${ERR_EXECSYS}
    fi

    PRINT_LOG "INFO" "Exec <hostname ${host_new_name}>... Ok"    
    return ${SUCCESS_CODE}
}



#==============================================================
## @Usage func_name 
## @Return ${SUCCESS_CODE}
## @Description main function
#==============================================================
function fn_main()
{
    local NEW_HOSTNAME
    local OLD_HOSTNAME
    local MODIFY_FILE
    local MODIFY_FILE="/etc/HOSTNAME /etc/hosts"
    
    #checking if the parameter of this script is not null , and provide the usage of this script    
    PRINT_LOG "INFO" "bash $0 $*"
    if [ $# -lt 1 ]
    then
        PRINT_LOG "FATAL" "Usage: $0 <config file>"
        PRINT_LOG "FATAL" "e.g:      $0 /opt/osmu/script/properties/sample.properties"
        return ${ERR_FILEEXIST}
    fi
    
    #checking if configuration file is exist, and read it to shell environment
    local CONFIG_FILE="$1"

    sed -i "s/[[:space:]]*$//g" "${CONFIG_FILE}"
    fn_check_config_file "${CONFIG_FILE}" || return $?
    NEW_HOSTNAME=`fn_get_value "${TMP_CONFIG_FILE}" "HOSTNAME"`
    OLD_HOSTNAME=`hostname`
    #checking parameter
    if [  -z "${NEW_HOSTNAME}" ] || [ -z "${OLD_HOSTNAME}" ]
    then
        PRINT_LOG "FATAL" "The param NEW_HOSTNAME<${NEW_HOSTNAME}>,OLD_HOSTNAME<${OLD_HOSTNAME}> is NULL"
        return ${ERROR_PARAM}
    fi

    #backup file before modify hostname
    fn_backup_file "${OLD_HOSTNAME}" "${MODIFY_FILE}" || return $?
    
    #modify hostname for OSMU host
    fn_modify_files "${OLD_HOSTNAME}" "${NEW_HOSTNAME}" "${MODIFY_FILE}" || return $?
    PRINT_LOG "INFO" "Execute modify all hostname successfully" 

    return ${SUCCESS_CODE}
}


#==============================================================
# main entrance
fn_main $@
MAIN_RET=$?
PRINT_LOG "INFO" "MAIN_RET=${MAIN_RET}"
FUNC_CLEAN_TMP_FILE
fn_write_operation_log "${MAIN_RET}"
exit ${MAIN_RET}
#==============================================================
