#!/bin/bash
#==============================================================
# Copyright  Huawei Technologies Co., Ltd. 1998-2012. All rights reserved.
# File Name             : setLocalLanguage.sh
# Version:Data          : 
# Description           : set language
# Others                : 
# History               : 
#==============================================================


MODULE_NAME="`basename $0 | sed 's/.sh//g'`"
RELATIVE_PATH="`dirname $0`"
    
#get absolute path 
cd "${RELATIVE_PATH}"
ABSOLUATELY_PATH=`pwd`
#import common variable..
. ../common/error_code.sh
. ../common/common.sh
cd - >/dev/null 2>&1


# Name        : fn_get_config
# Description : get the config from osmu
# Parameters  : $1 the absoluately path of config file 
# Parameter   : $2 the index of host
# Parameter   : $3 get slot number
# Parameter   : $4 get smm card ip
function fn_get_config()
{
    local TMP_CONFIG_FILE=$1 
    local config_language
    
    PRINT_LOG "INFO" "Loading <${TMP_CONFIG_FILE}>.." > /dev/null 2>&1
    
    config_language=`fn_get_value "${TMP_CONFIG_FILE}" "LANGUAGE"`
    if [ -z "${config_language}" ]
    then
        PRINT_LOG "WARN" "The param LANGUAGE<${config_language}> could not be found!" 
        return 1;
    fi
    
    eval $2="${config_language}"
        
    PRINT_LOG "INFO" "Loading <${TMP_CONFIG_FILE}>.. OK!!!" > /dev/null 2>&1
    return 0;
}


# Name        : fn_write_operation_log
# Description : write operation log
# Parameters  : $1 return value
function fn_write_operation_log()
{
    local RETCODE=$1
    who am i | egrep -w '([0-9]{1,3}\.){3}([0-9]{1,3})' &> /dev/null 
    if [ $? -eq 0 ]
    then
        OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
        OPERIP="${OPERIP//:*/}"
    else
        OPERIP=''
    fi
    
    if [ "${RETCODE}" = 0 ]
    then
        echo "`date` `hostname` `whoami` setLocalDate.sh;Successful;Set Date and Time Successfully." >> /var/log/localmessages
        echo "Set Date Successfully. "
    else
        echo "`date` `hostname` `whoami` setLocalDate.sh;Failed;Set Date and Time System Failed." >> /var/log/localmessages
        echo "Set Date Failed."
    fi    
    chmod 640 /var/log/localmessages
    
    return 0;
}

 
# Name        : fn_set_language
# Description : set language
function fn_set_language()
{
    local str_language=$1
 
    PRINT_LOG "INFO" "Setting language.."
    local language_file="/etc/sysconfig/language"
    if [ -f "${language_file}" ]
    then
        local tmp_language_file="${language_file}-bak"
        cp "${language_file}" "${tmp_language_file}"
        local str_format="UTF-8"
        grep "^RC_LANG=.*" ${language_file} > "${TMP_CONTENT_FILE}" 2>&1
        if [ $? -eq 0 ]
        then
            str_format=$(cat "${TMP_CONTENT_FILE}" | awk -F"." '{print $2}' | sed "s#\"##g")
            if [ -z "${str_format}" ]
            then
                str_format="UTF-8"
            fi
            sed -i "s#^RC_LANG=.*#RC_LANG=\"${str_language}.${str_format}\"#g" "${language_file}" > "${TMP_CONTENT_FILE}" 2>&1
            if [ $? -ne 0 ]
            then
                PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
                PRINT_LOG "WARN" "Exec sed command to replace RC_LANG failure!!!"
                cp "${tmp_language_file}" "${language_file}"
                return 1;
            fi
        else
            PRINT_LOG "WARN" "Can not find language config item<RC_LANG>, add RC_LANG=en_US.UTF-8 as the default."
            echo "RC_LANG=\"en_US.UTF-8\"" >> "${language_file}"
        fi
        
       grep "^RC_LC_ALL=.*" ${language_file} > "${TMP_CONTENT_FILE}" 2>&1
       if [ $? -eq 0 ]
       then
            sed -i "s#^RC_LC_ALL=.*#RC_LC_ALL=\"${str_language}.${str_format}\"#g" "${language_file}" > "${TMP_CONTENT_FILE}" 2>&1
            if [ $? -ne 0 ]
            then
                PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
                PRINT_LOG "WARN" "Exec sed command to replace RC_LC_ALL failure!!!"
                cp "${tmp_language_file}" "${language_file}"
                return 1;
            fi
       else
            PRINT_LOG "WARN" "Can not find language config item<RC_LC_ALL>, add RC_LC_ALL=en_US.UTF-8 as the default."
            echo "RC_LC_ALL=\"en_US.UTF-8\"" >> "${language_file}"
       fi
        
       grep "^ROOT_USES_LANG=.*" ${language_file} > "${TMP_CONTENT_FILE}" 2>&1
       if [ $? -eq 0 ]
       then
            sed -i "s#^ROOT_USES_LANG=.*#ROOT_USES_LANG=\"yes\"#g" "${language_file}" > "${TMP_CONTENT_FILE}" 2>&1
            if [ $? -ne 0 ]
            then
                PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
                PRINT_LOG "WARN" "Exec sed command to replace ROOT_USES_LANG failure!!!"
                cp "${tmp_language_file}" "${language_file}"
                return 1;
            fi
        else
            PRINT_LOG "WARN" "Can not find language config item<ROOT_USES_LANG>, add ROOT_USES_LANG=yes as the default."
            echo "ROOT_USES_LANG=\"yes\"" >> "${language_file}"
        fi
        
        local os_version_file_old="/etc/SuSE-release"
        local os_version_file_new="/etc/os-release"
        local suse_version="11"
        if [ -f "${os_version_file_new}" ]
        then
            PRINT_LOG "INFO" "Get os version from file ${os_version_file_new}"
            suse_version=$( cat ${os_version_file_new} | grep "^VERSION=" | awk -F"=" '{print $2}' | sed "s/^\"//g" | sed "s/\"$//g" | awk -F"-" '{print $1}' )
        elif [ -f "${os_version_file_old}" ]
        then
            PRINT_LOG "INFO" "Get os version from file ${os_version_file_old}"
            suse_version=$( cat ${os_version_file_old} | grep "^VERSION" | awk -F"=" '{print $2}' | xargs ) 
        else
            PRINT_LOG "FATAL" "Can not get os version."
            return 1
        fi
        PRINT_LOG "INFO" "Current os version:${suse_version}"
        
        if [ "${suse_version}" == "11" ]
        then
            PRINT_LOG "IFNO" "Start to execute SuSEconfig command"
            SuSEconfig > "${TMP_CONTENT_FILE}" 2>&1
            if [ $? -ne 0 ]
            then
                PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
                PRINT_LOG "WARN" "Exec SuSEconfig command failure!!!"
                cp "${tmp_language_file}" "${language_file}"
                return 1
            fi
            PRINT_LOG "IFNO" "end to execute SuSEconfig command"
        fi
    else
        PRINT_LOG "FATAL" "Can not find language config file."
        return 1
    fi
    
    PRINT_LOG "INFO" "Setting language.. OK!!!"
    return 0
}


function fn_main() 
{
    local REF_LANGUAGE

    PRINT_LOG "INFO" "bash $0 $*"
    if [ $# -lt 1 ]
    then
        PRINT_LOG "WARN" "Usage: $0 <config file>"
        PRINT_LOG "WARN" "e.g:      $0 /opt/osmu/script/properties/sample.properties"
        fn_check_status "${ERROR_PARAM}"
    fi
    
    CONFIG_FILE=`echo "$1" | sed 's/\\\/\//g'`

    sed -i "s/[[:space:]]*$//g" "${CONFIG_FILE}"
    fn_check_config_file "${CONFIG_FILE}" || return $?
    
    fn_title "Setting language .."


    fn_get_config "${TMP_CONFIG_FILE}" REF_LANGUAGE
    fn_check_status "$?"  "fn_get_config"

    fn_set_language "${REF_LANGUAGE}"
    fn_check_status "$?" "fn_set_language"

    return 0;
}

fn_main $@
RET=$?
fn_write_operation_log ${RET}
FUNC_CLEAN_TMP_FILE
exit ${RET}

