#!/bin/bash
getWorkPath()
{
    dir=`dirname $0`
    ispointstart=`echo $dir|awk -F/ '{print $1}'`
    if [ "$ispointstart" = "." ]
    then
        dir=`echo $dir|sed 's/^.//'`
        workfolder="`pwd`$dir"
    elif [ "$ispointstart" = ".." ]
    then
        workfolder="`pwd`/$dir"
    else
        workfolder="$dir"
    fi
    unallocation_size_file="${workfolder}/unallocation_size"
    disk_list_file="${workfolder}/disk_list"
}
getWorkPath

function do_exit()
{
    rm -rf $disk_list_file
    rm -rf $unallocation_size_file
    exit $1
}


OSType=""
if [ -f "/etc/SuSE-release" ];then
    OSType="SuSE"
elif [ -f "/etc/euleros-release" -a "`grep EulerOS /etc/euleros-release`" ];then
    OSType="EulerOS"
else
    echo "OS type not supported"
    do_exit 1
fi

dmidecode | grep 'Manufacturer' | egrep "VMware|OpenStack|QEMU" > /dev/null 2>&1
if [ $? -ne 0 ];then
    echo "Current environment is not VM."
    do_exit 1
fi

file "/dev/sda" | grep block > /dev/null 2>&1
 
if [ $? -ne 0 ];then
    sd_list=$(ls "/dev/vd"?)
 
else
    sd_list=$(ls "/dev/sd"?)
fi
echo $sd_list
echo "$sd_list" >${disk_list_file}
>${unallocation_size_file}
index=1
while read line
do
    sd_new=`echo ${line##*/}`
    #检查磁盘空间是否足够
    total=$(grep "${sd_new}$" /proc/partitions |awk '{print $3}');
    used=0
    for i in $(grep "${sd_new}[[:digit:]]\+$" /proc/partitions |awk '{print $3}' |xargs)
    do
    used=$(( used + i ));
    done

    unallocation_size=$((( total - used ) / (1024*1024) ))
    if [ $unallocation_size -gt 0 ];then
        # 判断主分区是否已满
        ls ${line}4 > /dev/null 2>&1
        if [ $? -ne 0 ];then
            echo ${index}. ${sd_new} ${unallocation_size} >> ${unallocation_size_file}
            index=`expr ${index} + 1`
        fi
    fi
done < ${disk_list_file}

avilable_count=`cat ${unallocation_size_file} | wc -l`
if [ ${avilable_count} -eq 0 ];then
    echo "no avalible disk found."
    do_exit 99
elif [ ${avilable_count} -eq 1 ];then
    sd_new=`cat ${unallocation_size_file} | awk '{print $2}'`
    extend_size=`cat ${unallocation_size_file} | awk '{print $3}'`
else
    echo "Which disk you would like to use to expand?"
    echo
    left_count=3
    while [ ${left_count} -gt 0 ];do
        cat ${unallocation_size_file}
        read select_index
        left_count=`expr ${left_count} - 1`
        select=`cat ${unallocation_size_file} | grep "^${select_index}."`
        if [ $? -ne 0 ];then
            
            if [ ${left_count} -eq 1 ];then
                echo "Invalid selection. ${left_count} time left"
            else
                echo "invalid selection. ${left_count} times left"
            fi
            echo
        else
            sd_new=`echo "${select}" | awk '{print $2}'`
            extend_size=`echo "${select}" | awk '{print $3}'`
            break
        fi
    done
    
    if [ ${left_count} -eq 0 ];then
        do_exit 1
    fi
fi

echo sd_new=$sd_new
echo extend_size=$extend_size
cur_part_num=`fdisk -l /dev/${sd_new} | grep "^/dev/${sd_new}" | awk '{print $1}' | grep "^/dev/${sd_new}[1-4]" | tail -1 | awk -F'/' '{print $3}'`
if [ ! -z ${cur_part_num} ];then
    new_part_num=`echo ${cur_part_num:3:4} + 1 | bc`
else
    new_part_num=1
fi

if [ ${new_part_num} -eq 1 ];then
        expect<<EOF
set timeout 60
spawn fdisk /dev/$sd_new
expect "*help):"
send "n\r"
expect "*primary*"
send "p\r"
expect { 
    "*Partition number*" { send "\r"; exp_continue }
    "*First sector*" { send "\r" }
}
expect "*Last sector*"
send "\r"
expect "*help*"
send "t\r"
expect "*type*"
send "8e\r"
expect "*help*"
send "w\r"
expect eof
EOF
else
    expect<<EOF
set timeout 60
spawn fdisk /dev/$sd_new
expect "*help):"
send "n\r"
expect "*primary*"
send "p\r"
expect { 
    "*Partition number*" { send "\r"; exp_continue }
    "*First sector*" { send "\r" }
}
expect "*Last sector*"
send "\r"
expect "*help*"
send "t\r"
expect "*Partition number*"
send "${new_part_num}\r"
expect "*type*"
send "8e\r"
expect "*help*"
send "w\r"
expect eof
EOF
fi


partprobe


pvcreate -ff /dev/${sd_new}${new_part_num}

vgextend vg_root /dev/${sd_new}${new_part_num}

extendValue=`echo "${extend_size} - 0.5"|bc`
part_label=`df | grep opt | awk '{print $1}' | awk -F "-" '{print($2)}'`
lvextend -L +${extendValue}G /dev/vg_root/$part_label
resize2fs /dev/vg_root/$part_label
lvdisplay /dev/vg_root/$part_label
do_exit 0
