#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
# File name: start.sh
# Description: the shell to start easysuite

real_path=$(readlink -f ${0})
if [ $? -eq 0 ]
then
    current_path=$(cd $(dirname ${real_path}); pwd)
else
    current_path=$(cd $(dirname ${0}); pwd)
fi
architecture=$(uname -i)
error_tips="The current system architecture is $architecture, Please check if your EasySuite package matches."
start_shell_log=$current_path'/var/run/log/start.log'
non_standard_path=("/tmp")
for i in ${non_standard_path[@]};
do
  if [[ $current_path == $i  ||  $current_path == "${i}/"* ]]
  then 
      echo "Easysuite is not allowed to run in non-standard path."
      echo "Non standard directories refer to the following directories: ${non_standard_path[@]}"
      exit 1
  fi
done
# Collect start time and reinforce code
# $1 = 0 print else no print
function echo_date()
{
    if (( $1 == 0 ))
    then
        echo $2
    fi
    echo [$(date +"%Y-%m-%d %H:%M:%S")] $2 >> $start_shell_log 2>&1
}


user=$(whoami)
if [ "${user}" != "root" ]
then
    echo_date 0 "The script must be run as the root user."
    exit 1
fi

unset SSH_AUTH_SOCK

es_path=$current_path'/easysuite'
python_path=$current_path'/easysuite/3rdparty/Python39'
python_bin_path=$current_path'/easysuite/3rdparty/Python39/bin/python3.9'
db_path=$current_path'/easysuite/db'
certs_path=$current_path'/easysuite/certs'
python_lib_path=$current_path'/easysuite/3rdparty/Python39/lib'
sqlite_path=$current_path'/easysuite/3rdparty/sqlite3/lib'
zip_tool_path=$current_path'/easysuite/3rdparty/7zip'
cloudsop_path=$current_path'/easysuite/3rdparty/cloudsop'
verify_tool_path=$current_path'/easysuite/3rdparty/VerificationTools'
easysuite_public_key=$current_path'/var/.easysuite/primary.ks'
easysuite_standby_key=$current_path'/var/.easysuite/standby.ks'
create_default_config=$current_path'/var/.easysuite/default_config.ini'
utils_path=$current_path'/easysuite/utils'
expansion_path=$current_path'/var/software/escompontent'
easysuite_log_path=$current_path'/var/run/log/easysuite.log'
export LD_LIBRARY_PATH=$python_lib_path:$current_path'/easysuite/lib':$es_path:$sqlite_path:$LD_LIBRARY_PATH
export PYTHONPATH=$python_lib_path:$current_path'/easysuite/lib':$es_path:$PYTHONPATH



echo "Starting, please wait..."

# unzip cloudsop file
echo "Start unzip osconfig and sudosconfig package ..."
if [ -f "$es_path/startup/bin/unzip_cloudsop.py" ] || [ -f "$es_path/startup/bin/unzip_cloudsop.pyc" ]; then
    nohup $python_bin_path -c "from startup.bin.unzip_cloudsop import unzip_cloudsop; unzip_cloudsop()" --noreload >/dev/null 2>&1
    if [ $? -ne 0 ]; then
        echo "Failed to unzip osconfig and sudoconfig package."
        echo $error_tips
        exit 1
    fi
    echo_date 0 "unzip osconfig and sudoconfig package succeeded."
else
    echo "Start failed, the file $es_path/startup/bin/unzip_cloudsop.py^(c^) does not exist!"
    exit 1
fi

# change 3rdparty tool permission
function change_3rdparty_permision()
{
    for target_dir in "$python_path/bin" "$zip_tool_path" "$verify_tool_path"
        do
            if [ -d "$target_dir" ]; then
                find $target_dir -type f | xargs -i echo "'{}'" | xargs chmod 550
            fi
        done
}
echo_date 1 "begin change_3rdparty_permision"
change_3rdparty_permision
echo_date 1 "end change_3rdparty_permision"

function create_libffi_link()
{
    libffi_name="libffi.so.6"
    libffi_files=`cd /usr/lib64 && ls | grep libffi`
    cd /usr/lib64
    if [ ! -f "$libffi_name" ]
    then
        for deal_file_name in ${libffi_files}
        do
            # 如果是软链接，跳过
            if [ -L "/usr/lib64/${deal_file_name}" ]
            then
                continue
            fi
            systemctl stop lock >/dev/null 2>&1
            cd /usr/lib64 && ln -s ${deal_file_name} ${libffi_name}
            break
        done
    fi
    systemctl start lock >/dev/null 2>&1
}

function replace_key() {
    if [ -f "$current_path/easysuite/replace_key.py" ]; then
        replace_key_file="$current_path/easysuite/replace_key.py"
    elif [ -f "$current_path/easysuite/replace_key.pyc" ]; then
        replace_key_file="$current_path/easysuite/replace_key.pyc"
    else
        echo_date 0 "Start failed, the file $current_path/easysuite/replace_key.py^(c^) does not exist!"
        exit 1
    fi
    $python_bin_path ${replace_key_file} true
    if [ $? -ne 0 ]; then
        echo_date 0 "first start replace key failed."
        exit 1
    fi
    echo_date 0 "first start replace key succeeded."
}

echo_date 1 "begin create_libffi_link"
create_libffi_link
echo_date 1 "end create_libffi_link"

python_start_file_path_py=$current_path'/easysuite/manage.py'
python_start_file_path_pyc=$current_path'/easysuite/manage.pyc'
python_start_file_path=''
if [ -f "$python_start_file_path_py" ]; then
    python_start_file_path=$python_start_file_path_py
elif [ -f "$python_start_file_path_pyc" ]; then
    python_start_file_path=$python_start_file_path_pyc
fi

echo_date 0 "Start loading MigrateSolution package ..."
if [ -f "$utils_path/migrate/load_migrate_solution/file_handling/load_migration_process.py" ]; then
    nohup $python_bin_path -c "import sys;sys.path.append('${es_path}');from utils.migrate.load_migrate_solution.file_handling import load_migration_process; load_migration_process.load_process()" --noreload >/dev/null 2>&1
elif [ -f "$utils_path/migrate/load_migrate_solution/file_handling/load_migration_process.pyc" ]; then
    nohup $python_bin_path -c "import sys;sys.path.append('${es_path}');from utils.migrate.load_migrate_solution.file_handling import load_migration_process; load_migration_process.load_process()" --noreload >/dev/null 2>&1
else
    echo_date 0 "Start failed, the file $utils_path/migrate/load_migrate_solution/file_handling/load_migration_process.py^(c^) does not exist!"
    exit 1
fi

a=$?
if [ ${a} -eq 2 ]; then
    echo_date 0 "Loading MigrateSolution failed, MigrateSolution signature file check error."
elif [ ${a} -eq 3 ]; then
    echo_date 0 "Loading MigrateSolution failed, MigrateSolution name error."
elif [ ${a} -eq 4 ]; then
    echo_date 0 "Loading MigrateSolution failed, MigrateSolution inner error."
    exit 4
elif [ ${a} -eq 0 ]; then
    echo_date 0 "Loading MigrateSolution succeeded."
fi

echo_date  0  "Start loading ESSolution package ..."
if [ -f "$es_path/startup/bin/start_plugin_prepare.py" ] || [ -f "$es_path/startup/bin/start_plugin_prepare.pyc" ]; then
    nohup $python_bin_path -c "from startup.bin.start_plugin_prepare import start_plugin_prepare; start_plugin_prepare()" --noreload >/dev/null 2>&1
else
    echo_date 0 "Start failed, the file $es_path/startup/bin/start_plugin_prepare.py^(c^) does not exist!"
    exit 1
fi

a=$?
if [ ${a} -eq 2 ]; then  
    echo_date 0 "Unzip Solution or Migrate zipfile failed, please check whether the zipfile is damaged or current path is too long."
    exit 2
elif [ ${a} -eq 3 ]; then  
    echo_date 0 "echo Copy template files to $current_path/'easysuite/plugin/' failed. because the current path is too long"
    exit 3
elif [ ${a} -eq 4 ]; then  
    echo_date 0 "Zip '*DeployTemplate.zip' or '*Expansion.zip' or 'Migrate.zip' failed."
    exit 4
elif [ ${a} -eq 5 ]; then  
    echo_date 0 "ESSolution or ESMigrate install package signature check failed."
    exit 5
elif [ ${a} -eq 6 ]; then  
    echo_date 0 "Make path '/var/software/Solution' or '/var/software/Migrate' failed."
    exit 6
elif [ ${a} -eq 8 ]; then  
    echo_date 0 "ESSolution or ESMigrate signature file cms or crl does not exist."
    exit 8
elif [ ${a} -eq 9 ]; then
    echo_date 0 "More than one ESSolution exists in the current path. Please remove the extra software packages and try again."
    exit 9
elif [ ${a} -eq 10 ]; then
    echo_date 0 "No matching ESSolution package is available and does not need to be loaded."
elif [ ${a} -eq 0 ]; then  
    echo_date 0 "Loading ESSolution product_apps success."
fi

restart_flag=$current_path'/restart.flag'
# 首次启动替换密钥
if [ ! -f ${restart_flag} ]; then
  echo_date 0 "begin replace_key"
  replace_key
  echo_date 0 "end replace_key"
  touch ${restart_flag}
  chmod 440 ${restart_flag}
fi


get_easysuite=`ps -ef | grep 19090 | grep easysuite | awk '{print $2}'`
if [ -z "$get_easysuite" ];then

    ip_arr=()
    # Obtain the IP address of the environment, excluding the IPv6 local link address.
    for i in `ip address show | grep inet | grep -v 127.0.0 | grep -v "scope link" | awk '{print $2}' | cut -d'/' -f1`
    do
        a=$i
        if [ $? == 0 -a $a != '127.0.0.1' -a $a != '::1' ]; then
            ip_arr[${#ip_arr[@]}]=$a
        fi
    done

    select_str=''
    echo_date 0 "Please select the ip to start easysuite:"
    for i in ${!ip_arr[@]}
    do
        num=$(($i+1))
        if [ ${#select_str} == 0 ]; then
            select_str=$select_str"$num"
        else
            select_str=$select_str"|$num"
        fi
        echo_date 0 "$num:${ip_arr[$i]}"
    done

    select_ip=''
    while true; 
    do
        stty -icanon min 0 time 100
        read -p "Please input the select("$select_str"):" select
        is_select_correct=`echo $select | sed -n '/^[0-9]\+$/p'`
        if [ -n "$is_select_correct" ]; then
            index=`echo $select|awk '{print int($0)}'`
            index=$(($index-1))
            if [ $index -lt ${#ip_arr[@]} -a $index -ge 0 ]; then
                select_ip=${ip_arr[$index]}
                break
            else
                echo_date 0 "select number is not valid, please select again."
            fi
        else
            echo_date 0 "select not correct,please select again."
        fi
    done
    if [ -n "$select_ip" ]; then
        # Check whether an IP address is an IPv6 or IPv4 address.
        echo_date 1 "begin python manager.py runsslserver"
        if echo "$select_ip" | grep : >/dev/null; then  
            nohup $python_bin_path $python_start_file_path runsslserver [$select_ip]:19090 --noreload --ipv6 >/dev/null 2>&1 &
        else
            nohup $python_bin_path $python_start_file_path runsslserver $select_ip:19090 --noreload >/dev/null 2>&1 &
        fi
        sleep 5
        get_easysuite_again=`ps -ef | grep 19090 | grep easysuite | awk '{print $2}'`
        count=1
        while true
        do
            if [ $count -gt 24 ];then
                echo_date 0 "start easysuite failed."
                logger -t $USER -p local0.err "start easysuite failed." >/dev/null 2>&1 &
                exit 1
            fi
            if [ $count -le 24 ];then
                get_easysuite_again=`ps -ef | grep 19090 | grep easysuite | awk '{print $2}'`
                if [ -n "$get_easysuite_again" ]; then
                    echo_date 0 "start easysuite success."
                    echo "[`date '+%Y-%m-%d %H:%M:%S'`] start easysuite success" >> $easysuite_log_path
                    logger -t $USER -p local0.err "start easysuite successfully." >/dev/null 2>&1 &
                    break
                else
                    echo_date 0 "easysuite is starting."
                    count=`expr $count + 1`
                    sleep 5
                    continue
                fi
            fi
        done
    fi
else
    echo_date 0 "easysuite is running already.Please run stop.sh to stop the easysuite first."
    exit 1
fi

echo_date 0 "Start zip software package ..."
if [ -f "$es_path/startup/bin/zip_process.py" ] || [ -f "$es_path/startup/bin/zip_process.pyc" ]; then
    nohup $python_bin_path -c "from startup.bin.zip_process import zip_process; zip_process()" --noreload >/dev/null 2>&1
else
    echo_date 0 "Zip failed, the file $es_path/startup/bin/zip_process.py^(c^) does not exist!"
    exit 1
fi

a=$?
if [ ${a} -eq 2 ]; then
    echo_date 0 "Unzip Solution or Migrate zipfile failed, please check whether the zipfile is damaged or the current path is too long."
    exit 2
elif [ ${a} -eq 3 ]; then
    echo_date 0 "echo Copy template files to '/var/software/escompontent/software' failed."
    exit 3
elif [ ${a} -eq 4 ]; then
    echo_date 0 "Zip '*DeployTemplate.zip' or '*Expansion.zip' or 'Migrate.zip' failed."
    exit 4
elif [ ${a} -eq 0 ]; then
    echo_date 0 "Zip package success."
fi

function change_permission()
{
    find $current_path -type d | xargs -i echo "'{}'" | xargs chmod 750 >/dev/null 2>&1
    find $current_path -type f | xargs -i echo "'{}'" | xargs chmod 640 >/dev/null 2>&1
    change_3rdparty_permision
    find $current_path -type f -name "*.sh" | xargs -i echo '"{}"' | xargs chmod 550 >/dev/null 2>&1 &
    find $certs_path -type f | xargs -i echo "'{}'" | xargs chmod 600 >/dev/null 2>&1 &
    find $current_path -type f -name "*.pem" -or -name "*.cer" -or -name "*.p12" -or -name "*.keystore" -or -name "*.jks" -or -name "*.crt" -or -name "*.der" -or -name "*.pfx" -or -name "*.cer" | xargs -i echo '"{}"' | xargs chmod 600 >/dev/null 2>&1 &
    find $current_path -type f -name "*.json" -print0 | xargs -0 grep -E -a "[a-zA-Z0-9]{45}" |grep -v site-packages |cut -d : -f 1 | xargs -i echo '"{}"' | xargs chmod 600 >/dev/null 2>&1 &
    find $current_path -type f -name "*.xml" -print0 | xargs -0 grep -E -a "[a-zA-Z0-9]{45}" |grep -v site-packages |cut -d : -f 1 | xargs -i echo '"{}"' | xargs chmod 600 >/dev/null 2>&1 &
    find $current_path -type f -name "*.conf" -print0 | xargs -0 grep -E -a "[a-zA-Z0-9]{45}" |grep -v site-packages |cut -d : -f 1 | xargs -i echo '"{}"' | xargs chmod 600 >/dev/null 2>&1 &
    find $current_path -type f -name "*.properties" -print0 | xargs -0 grep -E -a "[a-zA-Z0-9]{45}" |grep -v site-packages |cut -d : -f 1 | xargs -i echo '"{}"' | xargs chmod 600 >/dev/null 2>&1 &
    find $current_path -type f -print0 | xargs -0 grep 000000010000 2>&1 |grep -v site-packages |grep -v escompontent |cut -d : -f 1 |grep .json | xargs -i echo '"{}"' | xargs chmod 600 >/dev/null 2>&1 &

    find $current_path -type f -name "*.zip" -print0 | xargs -0 | grep -v site-packages |cut -d : -f 1 | xargs chmod 600 >/dev/null 2>&1 &
    if [ -d "${expansion_path}" ]; then
        find $expansion_path -type f -print0 | xargs -0 grep 000000010000 2>&1 |grep -v site-packages |cut -d : -f 1 |grep .json | xargs -i echo '"{}"' | xargs chmod 600 >/dev/null 2>&1 &
    fi
    if [ -f "$easysuite_public_key" ]; then
        chmod -R 600 $easysuite_public_key
    fi
    if [ -f "$easysuite_standby_key" ]; then
        chmod -R 600 $easysuite_standby_key
    fi
    if [ -f "$create_default_config" ]; then
        chmod -R 600 $create_default_config
    fi

    # 处理数据库文件权限
    chmod --silent 600 ${current_path}/easysuite/db/easysuite.sqlite3 &>/dev/null

    # 刷新敏感文件证书和密钥目录权限
    chmod --silent 700 ${current_path}/var/.easysuite ${current_path}/easysuite/certs &>/dev/null

    # 刷新敏感秘钥文件夹和密钥文件权限
    chmod --silent 700 ${current_path}/easysuite/easysuite/config &>/dev/null
    chmod --silent 600 ${current_path}/easysuite/easysuite/config/default_config.properties &>/dev/null
    chmod --silent 600 ${current_path}/easysuite/easysuite/config/db_weakword.conf &>/dev/null
}
echo_date 1 "begin change_permission"
change_permission
echo_date 1 "end change_permission"
