#!/bin/bash
. /etc/profile
#install dir
installDir=/opt/expansion
#icmr sofrware package
icmrPackage="iMasterNCE.*\ICMR_linux-.*64.zip"
#uniep package
uniep="iMasterNCE.*\OMP_linux-.*64"
#EasySuite package
EasySuitePackage="iMasterNCE.*\EasySuite"
#nce package
ncePackage="iMasterNCE.*"

createCheckFile()
{
   
    echo "#!/bin/bash
echo  RESULT:1   
   ">/opt/expansion/check_product_result.sh
 
   chmod 550 /opt/expansion/check_product_result.sh
}
#getWorkPath
GetWorkPath()
{
    dir=`dirname $0`
    ispointstart=`echo $dir|awk -F/ '{print $1}'`
    if [ "$ispointstart" = "." ]
    then
        dir=`echo $dir|sed 's/^.//'`
        curPath="`pwd`$dir"
    elif [ "$ispointstart" = ".." ]
    then
        curPath="`pwd`/$dir"
    else
        curPath="$dir"
    fi
    return 0
}

#check root user
CheckUser()
{
    USER_ID=`id -u`
    if [ $USER_ID -ne 0 ]
    then
        echo "Run the script as the root user."
        return 1
    fi

    return 0
}

getcheckResult()
{
   if [ $1 -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf /opt/expansion/check_product_result.sh
   ">/opt/expansion/check_product_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf /opt/expansion/check_product_result.sh
   ">/opt/expansion/check_product_result.sh
   fi
   chmod 550 /opt/expansion/check_product_result.sh > /dev/null 2>&1
}

#log
OperateLog()
{
    if [ -f "/opt/NCEICMR/scripts/OperationLog/businessoperatelog.sh" ]
    then
        bash /opt/NCEICMR/scripts/OperationLog/businessoperatelog.sh "$1" "$2"
        return
    fi
}

#install product
Install()
{
    #installproduct.sh
    if [ "$#" -eq "2" -a "$2" = "add" ]
    then
        su - ossadm -c "cd /opt/oss/manager/tools/deployapp && unbuffer bash installproduct.sh -input $installDir/input.json -mode add"
    else
    su - ossadm -c "cd /opt/oss/manager/tools/deployapp && unbuffer bash installproduct.sh -input $installDir/input.json"
    fi
    if [ $? -ne 0 ]
    then
        OperateLog "Error: Install product: installproduct failed, rendering the install_uniep.sh script failed." "error"
        return 1
    fi
    
    return 0
}

Main()
{
    GetWorkPath
    createCheckFile
    CheckUser
    if [ $? -ne 0 ]
    then
        OperateLog "Error: Failed to check the logged-in user, rendering the install_uniep.sh script failed." "error"
        return 1
    fi
    #install
    Install $*
    if [ $? -ne 0 ]
    then
        OperateLog "Error: Failed to init the software package, rendering the install_uniep.sh script failed." "error"
        return 1
    fi
    
   return 0
}

Main $*
getcheckResult $?
exit $?