#!/bin/bash


if [ ! -d "/opt/oss/secsoter" ]
then
    echo "/opt/oss/secsoter is not found, skip update service virtual patch."
    exit 0
fi

expansion_after_tmp=/opt/expansion_backup/expansion_after_tmp

su - ossadm -c "mkdir -p ${expansion_after_tmp} && cd /opt/oss/manager/tools/resmgr;./queryproduct.sh -pn all -output ${expansion_after_tmp}"

if [ -f "/opt/expansion/update_environment_patch.pyc" ]
then
    UPDATE_ENV_PATCH_FILE=update_environment_patch.pyc
else
    if [ -f "/opt/expansion/update_environment_patch.py" ]
    then
        UPDATE_ENV_PATCH_FILE=update_environment_patch.py
    else
        echo "Error: Can not find update_environment_patch file"
    fi
fi

chown ossadm:ossgroup /opt/expansion/${UPDATE_ENV_PATCH_FILE}

su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh; python /opt/expansion/${UPDATE_ENV_PATCH_FILE}"

exit $?