#!/bin/bash

FileName="add_srv.sh"
vgname="vg_srv"
mountfile="/etc/fstab"
#获取空闲磁盘列表
GetFreeDiskList()
{
    ret=""
    for disk in `fdisk -l | grep "Disk /dev" | grep -v "mapper" | grep -v "/dev/.da" | awk '{print $2}' | awk -F ":" '{print $1}'`
    do
        parted -s $disk print 2>/dev/null | grep -i "lvm" >/dev/null 2>&1
        if [ $? -ne 0 ]
        then
            parted -s $disk print 2>/dev/null | grep -i "primary" >/dev/null 2>&1
            if [ $? -ne 0 ]
            then
                if [ "x$ret" = "x" ]
                then
                    ret="$disk"
                else
                    ret="$ret\n$disk"
                fi
            fi    
        fi
    done
    echo -e $ret
}

#创建分区
CreatePartition()
{
    which parted >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        echo "Warning, Command parted not found."
        logger -t $USER -p local0.err "$FileName; Warning, Command parted not found. ${OPERIP:-127.0.0.1}"
        return 1
    fi
    parted -s $1 mklabel gpt
    parted -s $1 -- mkpart primary 0 -1 >/dev/null 2>&1
    parted -s $1 set 1 lvm on
    
    sleep 2
    #刷新分区表
    partprobe >/dev/null 2>&1
    sleep 2
    pr=$(fdisk -l $1 | grep -i "lvm" | awk -F " " '{print $1}')
    if [ ${pr} = "$1"1 ]
    then
        echo "Information, Command parted executed successful."
        logger -t $USER -p local0.err "$FileName; information, Command parted executed successful. ${OPERIP:-127.0.0.1}."
        return 0
    else
        echo "Warning, Command parted executed failed. disk is $1"
        logger -t $USER -p local0.err "$FileName; Warning, Command parted executed failed. ${OPERIP:-127.0.0.1}, disk is $1."
        return 1
    fi
}

#获取卷组剩余空间
GetVGSize()
{
    #Free  PE / Size       113920 / 445.00 GiB
    vgsize=`vgdisplay 2>/dev/null $1 | grep "Free *PE */ *Size" | awk -F"/" '{print $2}' | awk '{print $2}'`
    
    #113920,减少50个(防止计算不准确)
    vgsize=`expr $vgsize - 50`
    echo $vgsize
}

# 激活卷组，防止未激活导致分区创建失败
# $1 = vg_srv1
CheckVG()
{
    sleep 2
    pvscan | grep "$1" > /dev/null
    if [ $? -ne 0 ]
    then
        echo "$FileName; Error, Execute failed, pvscan failed. ${OPERIP:-127.0.0.1}, can not found VG $1, sleep 5s then check again."
        logger -t $USER -p local0.err "$FileName; Error, Execute failed, pvscan failed. ${OPERIP:-127.0.0.1}, can not found VG $1, sleep 5s then check again."
        sleep 5
        pvscan -vvvv
        pvscan | grep "$1" > /dev/null
        if [ $? -ne 0 ]
        then
            echo "$FileName; Error, Execute failed, pvscan again failed. ${OPERIP:-127.0.0.1}, can not found VG $1"
            logger -t $USER -p local0.err "$FileName; Error, Execute failed, pvscan again failed. ${OPERIP:-127.0.0.1}, can not found VG $1"
            return 1
        fi
    fi
    sleep 2
    vgscan
    sleep 2
    vgchange -ay $1
    if [ $? -ne 0 ]
    then
        echo "$FileName; Error, Execute failed, vgchange failed. ${OPERIP:-127.0.0.1}, VG $1"
        logger -t $USER -p local0.err "$FileName; Error, Execute failed, vgchange failed. ${OPERIP:-127.0.0.1}, VG $1"
        return 1
    fi
    sleep 2
    return 0
}

# x86场景
CreateLV_x86()
{
    i=1
    for disk in $1
    do
        #创建LVM分区(只有一个分区:${disk}1)
        CreatePartition "$disk"
        if [ $? -ne 0 ]
        then
            return 1
        fi
        #
        pvcreate "${disk}1"
        if [ $? -ne 0 ]
        then
            echo "$FileName; Error, Execute failed, pvcreate failed. ${OPERIP:-127.0.0.1}, disk is ${disk}1"
            logger -t $USER -p local0.err "$FileName; Error, Execute failed, pvcreate failed. ${OPERIP:-127.0.0.1}, disk is ${disk}1"
            return 1
        else
            echo "$FileName; pvcreate successful. ${OPERIP:-127.0.0.1}, disk is ${disk}1"
            logger -t $USER -p local0.err "$FileName; pvcreate successful. ${OPERIP:-127.0.0.1}, disk is ${disk}1"
        fi
        sleep 2
        #创建新卷组
        vgcreate $vgname${i} "${disk}1"
        if [ $? -ne 0 ]
        then
            echo "$FileName; Error, Execute failed, vgcreate failed. ${OPERIP:-127.0.0.1}, disk is ${disk}1"
            logger -t $USER -p local0.err "$FileName; Error, Execute failed, vgcreate failed. ${OPERIP:-127.0.0.1}, disk is ${disk}1"
            return 1
        else
            echo "$FileName; vgcreate successful. ${OPERIP:-127.0.0.1}, disk is ${disk}1, vg is ${vgname}${i}"
            logger -t $USER -p local0.err "$FileName; vgcreate successful. ${OPERIP:-127.0.0.1}, disk is ${disk}1, vg is ${vgname}${i}"
        fi
        # 激活卷组，防止未激活导致分区创建失败
        CheckVG $vgname${i}
        if [ $? -ne 0 ]
        then
            echo "$FileName; Error, Execute failed, CheckVG failed. ${OPERIP:-127.0.0.1}, VG is $vgname${i}"
            logger -t $USER -p local0.err "$FileName; Error, Execute failed, CheckVG failed. ${OPERIP:-127.0.0.1}, VG is $vgname${i}"
            return 1
        fi
        # 创建分区
        total_row=`sed -n '$=' srv.conf`
        for ((row=1;row<=$total_row;row++));
        do
            line=`sed -n "${row}p" srv.conf`
            mount_path=`echo "$line"|awk '{print $1}'`
            lvname=`echo "$line"|awk '{print $2}'`
            lvsize=`echo "$line"|awk '{print $3}'`
            if [ "x$lvsize" = "xothers" ]
            then
                #获取VG组剩余大小
                vgfreesize=`GetVGSize $vgname${i}`
                echo y | lvcreate -l ${vgfreesize} -n $lvname $vgname${i}
            else
                echo $lvsize | grep "%" > /dev/null
                if [ $? -eq 0 ]
                then
                    #获取VG组剩余大小
                    vgfreesize=`GetVGSize $vgname${i}`
                    temp=`echo ${lvsize//%/}`
                    lv_real_size=`echo ${vgfreesize}*${temp}/100|bc`
                    echo y | lvcreate -l ${lv_real_size} -n $lvname $vgname${i}
                else
                    echo y | lvcreate -L $lvsize -n $lvname $vgname${i}
                fi
            fi
            if [ $? -ne 0 ]
            then
                echo "$FileName; Error, Execute failed, lvcreate $lvname failed. vg is $vgname${i}."
                logger -t $USER -p local0.err "$FileName; Error, Execute failed, lvcreate $lvname failed. ${OPERIP:-127.0.0.1}, vg is $vgname${i}."
                return 1
            fi
            mkfs.ext4 /dev/$vgname${i}/$lvname
            if [ $? -ne 0 ]
            then
                echo "$FileName; Error, Execute failed, mkfs $lvname failed. lv is /dev/$vgname${i}/$lvname."
                logger -t $USER -p local0.err "$FileName; Error, Execute failed, mkfs $lvname failed. ${OPERIP:-127.0.0.1}, lv is /dev/$vgname${i}/$lvname."
                return 1
            fi
            mkdir -p $mount_path
            mount -o nodev /dev/$vgname${i}/$lvname $mount_path
            if [ $? -ne 0 ]
            then
                echo "$FileName; Error, Execute failed, mount $lvname failed. lv is /dev/$vgname${i}/$lvname, path is $mount_path."
                logger -t $USER -p local0.err "$FileName; Error, Execute failed, mount $lvname failed. ${OPERIP:-127.0.0.1}, lv is /dev/$vgname${i}/$lvname, path is $mount_path."
                return 1
            fi
            #注册启动挂接
            cat ${mountfile} | grep " $mount_path " > /dev/null 2>&1
            if [ $? -ne 0 ]
            then
                echo -e "/dev/$vgname${i}/$lvname $mount_path ext4 nodev 0 0" >> ${mountfile}
            fi
        done
        i=`echo $i+1|bc`
        # FI文档分区内容不对，在仅有1个硬盘时，按理只应存在data1目录，实际会存在data2、data3，分区时只能到上级目录，只处理一个硬盘，后续多个硬盘再说
        break
    done
    logger -t $USER -p local0.err "$FileName; information, Execute successful. ${OPERIP:-127.0.0.1}."
    return 0
}

# arm场景
CreateLV_arm()
{
    i=1
    for disk in $1
    do
        [ ${i} -gt 3 ] && break
        #创建LVM分区(只有一个分区:${disk}1)
        CreatePartition "${disk}"
        if [ $? -ne 0 ]
        then
            return 1
        fi
        #
        pvcreate "${disk}1"
        if [ $? -ne 0 ]
        then
            echo "$FileName; Error, Execute failed, pvcreate failed. ${OPERIP:-127.0.0.1}, disk is ${disk}1"
            logger -t $USER -p local0.err "$FileName; Error, Execute failed, pvcreate failed. ${OPERIP:-127.0.0.1}, disk is ${disk}1"
            return 1
        else
            echo "$FileName; pvcreate successful. ${OPERIP:-127.0.0.1}, disk is ${disk}1"
            logger -t $USER -p local0.err "$FileName; pvcreate successful. ${OPERIP:-127.0.0.1}, disk is ${disk}1"
        fi
        sleep 2
        #创建新卷组
        vgcreate ${vgname}${i} "${disk}1"
        if [ $? -ne 0 ]
        then
            echo "$FileName; Error, Execute failed, vgcreate failed. ${OPERIP:-127.0.0.1}, disk is ${disk}1"
            logger -t $USER -p local0.err "$FileName; Error, Execute failed, vgcreate failed. ${OPERIP:-127.0.0.1}, disk is ${disk}1"
            return 1
        else
            echo "$FileName; vgcreate successful. ${OPERIP:-127.0.0.1}, disk is ${disk}1, vg is ${vgname}${i}"
            logger -t $USER -p local0.err "$FileName; vgcreate successful. ${OPERIP:-127.0.0.1}, disk is ${disk}1, vg is ${vgname}${i}"
        fi
        # 激活卷组，防止未激活导致分区创建失败
        CheckVG $vgname${i}
        if [ $? -ne 0 ]
        then
            echo "$FileName; Error, Execute failed, CheckVG failed. ${OPERIP:-127.0.0.1}, VG is $vgname${i}"
            logger -t $USER -p local0.err "$FileName; Error, Execute failed, CheckVG failed. ${OPERIP:-127.0.0.1}, VG is $vgname${i}"
            return 1
        fi
        i=`echo $i+1|bc`
    done
    total_row=`sed -n '$=' srv.conf`
    for ((row=1;row<=$total_row;row++));
    do
        line=`sed -n "${row}p" srv.conf`
        mount_path=`echo "$line"|awk '{print $1}'`
        lvname=`echo "$line"|awk '{print $2}'`
        lvsize=`echo "$line"|awk '{print $3}'`
        while true
        do
            case ${lvname} in
                lv_srv_bigdata | lv_log_bigdata )
                    vg_real_name="${vgname}"1
                    break
                    ;;
                lv_hadoop )
                    vg_real_name="${vgname}"2
                    break
                    ;;
                lv_kafka )
                    vg_real_name="${vgname}"3
                    lvsize="100G"
                    break
                    ;;
                lv_druid )
                    vg_real_name="${vgname}"3
                    lvsize="others"
                    break
                    ;;
                *)
                    echo "Warning, Unknown lvname ${lvname}."
                    logger -t $USER -p local0.err "$FileName; Warning, Unknown lvname ${lvname}; ${OPERIP:-127.0.0.1}."
                    break
                    ;;
            esac
        done
        if [ "x$lvsize" = "xothers" ] || [ "x${lvname}" = "xlv_log_bigdata" ]
        then
            #获取VG组剩余大小
            vgfreesize=`GetVGSize ${vg_real_name}`
            echo y | lvcreate -l ${vgfreesize} -n ${lvname} ${vg_real_name}
        else
            echo ${lvsize} | grep "%" > /dev/null
            if [ $? -eq 0 ]
            then
                #获取VG组剩余大小
                vgfreesize=`GetVGSize ${vg_real_name}`
                temp=`echo ${lvsize//%/}`
                lv_real_size=`echo ${vgfreesize}*${temp}/100|bc`
                echo y | lvcreate -l ${lv_real_size} -n ${lvname} ${vg_real_name}
            else
                echo y | lvcreate -L ${lvsize} -n ${lvname} ${vg_real_name}
            fi
        fi
        if [ $? -ne 0 ]
        then
            echo "${FileName}; Error, Execute failed, lvcreate ${lvname} failed. vg is ${vg_real_name}."
            logger -t $USER -p local0.err "${FileName}; Error, Execute failed, lvcreate ${lvname} failed. ${OPERIP:-127.0.0.1}, vg is ${vg_real_name}."
            return 1
        fi
        mkfs.ext4 /dev/${vg_real_name}/${lvname}
        if [ $? -ne 0 ]
        then
            echo "${FileName}; Error, Execute failed, mkfs ${lvname} failed. lv is /dev/${vg_real_name}/${lvname}."
            logger -t $USER -p local0.err "${FileName}; Error, Execute failed, mkfs ${lvname} failed. ${OPERIP:-127.0.0.1}, lv is /dev/${vg_real_name}/${lvname}."
            return 1
        fi
        mkdir -p ${mount_path}
        mount -o nodev /dev/${vg_real_name}/${lvname} ${mount_path}
        if [ $? -ne 0 ]
        then
            echo "${FileName}; Error, Execute failed, mount ${lvname} failed. lv is /dev/${vg_real_name}/${lvname}, path is ${mount_path}."
            logger -t $USER -p local0.err "${FileName}; Error, Execute failed, mount ${lvname} failed. ${OPERIP:-127.0.0.1}, lv is /dev/${vg_real_name}/${lvname}, path is ${mount_path}."
            return 1
        fi
        #注册启动挂接
        cat ${mountfile} | grep " ${mount_path} " > /dev/null 2>&1
        if [ $? -ne 0 ]
        then
            echo -e "/dev/${vg_real_name}/${lvname} ${mount_path} ext4 nodev 0 0" >> ${mountfile}
        fi
    done
    logger -t $USER -p local0.err "${FileName}; information, Execute successful. ${OPERIP:-127.0.0.1}."
    return 0
}

SetDirOssuserPermission()
{
    srv_bigdata_path=`head -n 1 srv.conf|awk '{print $1}'`
    chown -R 3004:2000 ${srv_bigdata_path}
    if [ $? -ne 0 ]
    then
        echo "$FileName; Error, Execute failed, set ${srv_bigdata_path} ossuser permission failed."
        logger -t $USER -p local0.err "$FileName; Error, Execute failed, set ${srv_bigdata_path} ossuser permission failed. ${OPERIP:-127.0.0.1}"
        return 1
    fi
}

MkDir()
{
    back_dir=/opt/backup
    hd_back_dir=/opt/backup/ncendp
    # 如果存在平台备份目录直接创建hd备份目录,不存在则创建hd目录同时恢复平台备份目录
    if [[ -d ${back_dir} ]]; then
        mkdir -p ${hd_back_dir} && chown 3004:2000 ${hd_back_dir} && chmod 700 ${hd_back_dir}
    else
        mkdir -p ${hd_back_dir} && chown 3004:2000 ${hd_back_dir} && chmod 700 ${hd_back_dir}
        chown 0:2000 ${back_dir} && chmod 750 ${back_dir}
    fi

    if [ $? -ne 0 ]
    then
        echo "$FileName; Error, Execute failed, creat ${hd_back_dir} failed."
        logger -t $USER -p local0.err "$FileName; Error, Execute failed, creat ${hd_back_dir} failed. ${OPERIP:-127.0.0.1}"
        return 1
    fi
}

main()
{
    df -h|grep "/srv" >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        echo "Warning, The OS data partition exist, can not add again."
        # 设置/srv/BigData目录权限
        SetDirOssuserPermission

        # 创建 /opt/backup/ncendp
        MkDir
        logger -t $USER -p local0.err "$FileName; Warning, The OS data partition exist, can not add again; ${OPERIP:-127.0.0.1}."
        return 0
    fi
    
    #获取挂接阵列硬盘
    freedisks=`GetFreeDiskList`
    total_freedisks=$(echo "${freedisks}" | wc -w)
    if [ "x$freedisks" = "x" ]
    then
        echo "Warning, There are not any free disks exist, can not process."
        lsblk
        logger -t $USER -p local0.err "$FileName; Warning, There are not any free disks exist, can not process. ${OPERIP:-127.0.0.1}."
        return 1
    fi
    if [ ${total_freedisks} -ge 3 ]
    then
        ret=""
        for disk in $freedisks
        do
            fdisksize=`fdisk -ls $disk`
            #如果磁盘大于95G小于410G,认为是泰山一体机场景的那块RAID10硬盘
            if [ "${fdisksize}" -lt 429916160 -a "${fdisksize}" -gt 99614720 ]
            then
                smalldisk="$disk"
            else
                if [ "x$ret" = "x" ]
                then
                    ret="$disk"
                else
                    ret="$ret\n$disk"
                fi
            fi
        done
        freedisks=`echo -e "$smalldisk\n$ret"`
        CreateLV_arm "${freedisks}"
    else
        CreateLV_x86 "${freedisks}"
    fi

    # 设置/srv/BigData目录权限
    SetDirOssuserPermission

    # 创建 /opt/backup/ncendp
    MkDir
}

main > $FileName.log 2>&1
ret=$?
if [ $ret -ne 0 ]
then
    cat $FileName.log
    echo "[`date '+%Y-%m-%d %H:%M:%S'`]Error : add_srv failed. " 1>&2
else
    echo "Info: Execute successful."
fi
exit $ret
